/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.autoconfigure;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.task.SimpleAsyncTaskExecutorCustomizer;
import org.springframework.boot.task.ThreadPoolTaskExecutorCustomizer;
import org.springframework.boot.thread.Threading;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.ContextPropagatingTaskDecorator;
import org.springframework.modulith.observability.ModulithEventMetricsCustomizer;
import org.springframework.modulith.observability.support.CrossModuleEventCounterFactory;
import org.springframework.modulith.observability.support.LocalServiceRenamingSpanFilter;
import org.springframework.modulith.observability.support.ModuleEventListener;
import org.springframework.modulith.observability.support.ModuleObservabilityBeanPostProcessor;
import org.springframework.modulith.observability.support.ModulePassingObservationFilter;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"management.tracing.enabled"}, havingValue="true", matchIfMissing=true)
class ModuleObservabilityAutoConfiguration {
    ModuleObservabilityAutoConfiguration() {
    }

    @Bean
    static ModuleObservabilityBeanPostProcessor moduleTracingBeanPostProcessor(ApplicationModulesRuntime runtime, ObjectProvider<ObservationRegistry> observationRegistry, ConfigurableListableBeanFactory factory, Environment environment) {
        return new ModuleObservabilityBeanPostProcessor(runtime, () -> observationRegistry.getObject(), factory, environment);
    }

    @Bean
    static ModuleEventListener tracingModuleEventListener(ApplicationModulesRuntime runtime, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<MeterRegistry> meterRegistry, CrossModuleEventCounterFactory configurer) {
        return new ModuleEventListener(runtime, () -> observationRegistry.getObject(), () -> meterRegistry.getObject(), configurer);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    SimpleAsyncTaskExecutorCustomizer simpleAsyncTaskExecutorCustomizer() {
        return executor -> executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
    }

    @Bean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    ThreadPoolTaskExecutorCustomizer threadPoolTaskExecutorCustomizer() {
        return executor -> executor.setTaskDecorator((TaskDecorator)new ContextPropagatingTaskDecorator());
    }

    @Bean
    ObservationFilter modulePassingObservationFilter() {
        return new ModulePassingObservationFilter();
    }

    @Bean
    LocalServiceRenamingSpanFilter localServiceRenamingSpanFilter() {
        return new LocalServiceRenamingSpanFilter();
    }

    @Bean
    CrossModuleEventCounterFactory modulithEventCounterFactory(ObjectProvider<ModulithEventMetricsCustomizer> customizer) {
        CrossModuleEventCounterFactory factory = new CrossModuleEventCounterFactory();
        customizer.stream().forEach(it -> it.customize(factory));
        return factory;
    }
}

