/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.observability.support;

import io.micrometer.common.KeyValue;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationView;
import java.util.Objects;
import org.springframework.modulith.observability.support.ModulithObservations;

public class ModulePassingObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        if (ModulePassingObservationFilter.isModuleKeyValueAbsentInCurrent((Observation.ContextView)context) && ModulePassingObservationFilter.isModuleKeyValuePresentInParent((Observation.ContextView)context)) {
            ModulithObservations.LowKeys moduleKey = ModulithObservations.LowKeys.MODULE_KEY;
            ObservationView parent = Objects.requireNonNull(context.getParentObservation());
            KeyValue moduleValue = Objects.requireNonNull(parent.getContextView().getLowCardinalityKeyValue(moduleKey.asString()));
            return context.addLowCardinalityKeyValue(moduleKey.withValue(moduleValue.getValue()));
        }
        return context;
    }

    private static boolean isModuleKeyValueAbsentInCurrent(Observation.ContextView context) {
        return context.getLowCardinalityKeyValue(ModulithObservations.LowKeys.MODULE_KEY.asString()) == null;
    }

    private static boolean isModuleKeyValuePresentInParent(Observation.ContextView context) {
        ObservationView parentObservation = context.getParentObservation();
        return parentObservation != null && parentObservation.getContextView().getLowCardinalityKeyValue(ModulithObservations.LowKeys.MODULE_KEY.asString()) != null;
    }
}

