/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.modulith.runtime.ApplicationRuntime;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class SpringBootApplicationRuntime
implements ApplicationRuntime {
    private static final Map<String, Boolean> APPLICATION_CLASSES = new ConcurrentHashMap<String, Boolean>();
    private final ApplicationContext context;
    private Class<?> mainApplicationClass;

    SpringBootApplicationRuntime(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null!");
        this.context = context;
    }

    @Override
    public String getId() {
        return this.context.getId();
    }

    @Override
    public Class<?> getMainApplicationClass() {
        if (this.mainApplicationClass == null) {
            this.mainApplicationClass = Arrays.stream(this.context.getBeanDefinitionNames()).filter(it -> this.context.findAnnotationOnBean(it, SpringBootApplication.class, false) != null).map(arg_0 -> ((ApplicationContext)this.context).getType(arg_0)).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find a class annotated with @SpringBootApplication!"));
        }
        return this.mainApplicationClass;
    }

    @Override
    public Class<?> getUserClass(Object bean, String beanName) {
        Class beanType = this.context.containsBean(beanName) ? this.context.getType(beanName) : bean.getClass();
        return ClassUtils.getUserClass((Class)beanType);
    }

    @Override
    public boolean isApplicationClass(Class<?> type) {
        Class<?> applicationClass = this.getMainApplicationClass();
        return APPLICATION_CLASSES.computeIfAbsent(type.getName(), it -> this.computeIsApplicationClass((String)it, applicationClass));
    }

    private boolean computeIsApplicationClass(String fqn, Class<?> applicationClass) {
        if (fqn.startsWith("org.springframework")) {
            return false;
        }
        return fqn.startsWith(applicationClass.getPackage().getName()) || AutoConfigurationPackages.get((BeanFactory)this.context).stream().anyMatch(pkg -> fqn.startsWith((String)pkg));
    }
}

