/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ApplicationModulesFactory;
import org.springframework.modulith.core.FormattableType;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.modulith.runtime.ApplicationRuntime;
import org.springframework.modulith.runtime.autoconfigure.MissingRuntimeDependency;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingSupplier;

@AutoConfiguration
class SpringModulithRuntimeAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringModulithRuntimeAutoConfiguration.class);
    private static final AsyncTaskExecutor EXECUTOR = new SimpleAsyncTaskExecutor();

    SpringModulithRuntimeAutoConfiguration() {
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean(value={ApplicationRuntime.class})
    static ApplicationRuntime modulithsApplicationRuntime(ApplicationContext context) {
        return ApplicationRuntime.of(context);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnMissingBean
    static ApplicationModulesRuntime modulesRuntime(ApplicationRuntime runtime) {
        ThrowingSupplier modules = () -> (ApplicationModules)EXECUTOR.submit(() -> ApplicationModulesBootstrap.initializeApplicationModules(runtime.getMainApplicationClass())).get();
        return new ApplicationModulesRuntime((Supplier<ApplicationModules>)modules, runtime);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBean(value={ApplicationModuleInitializer.class})
    static ApplicationListener<ApplicationStartedEvent> applicationModuleInitializingListener(ObjectProvider<ApplicationModulesRuntime> runtime, ObjectProvider<ApplicationModuleInitializer> initializers) {
        return event -> {
            ApplicationModules modules = ((ApplicationModulesRuntime)runtime.getObject()).get();
            initializers.stream().sorted(modules.getComparator()).map(it -> LOGGER.isDebugEnabled() ? new LoggingApplicationModuleInitializerAdapter((ApplicationModuleInitializer)it, modules) : it).forEach(ApplicationModuleInitializer::initialize);
        };
    }

    private static class LoggingApplicationModuleInitializerAdapter
    implements ApplicationModuleInitializer {
        private static final Logger LOGGER = LoggerFactory.getLogger(LoggingApplicationModuleInitializerAdapter.class);
        private final ApplicationModuleInitializer delegate;
        private final ApplicationModules modules;

        public LoggingApplicationModuleInitializerAdapter(ApplicationModuleInitializer delegate, ApplicationModules modules) {
            Assert.notNull((Object)delegate, (String)"ApplicationModuleInitializer must not be null!");
            Assert.notNull((Object)modules, (String)"ApplicationModules must not be null!");
            this.delegate = delegate;
            this.modules = modules;
        }

        public void initialize() {
            Class listenerType = AopUtils.getTargetClass((Object)this.delegate);
            FormattableType formattable = FormattableType.of((Class)listenerType);
            String formattedListenerType = this.modules.getModuleByType(listenerType).map(arg_0 -> ((FormattableType)formattable).getAbbreviatedFullName(arg_0)).orElseGet(() -> ((FormattableType)formattable).getAbbreviatedFullName());
            LOGGER.debug("Initializing {}.", (Object)formattedListenerType);
            this.delegate.initialize();
            LOGGER.debug("Initializing {} done.", (Object)formattedListenerType);
        }
    }

    private static class ApplicationModulesBootstrap {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesBootstrap.class);
        private static final ApplicationModulesFactory BOOTSTRAP;

        private ApplicationModulesBootstrap() {
        }

        static ApplicationModules initializeApplicationModules(Class<?> applicationMainClass) {
            LOGGER.debug("Obtaining Spring Modulith application modules\u2026");
            ApplicationModules result = BOOTSTRAP.of(applicationMainClass);
            long numberOfModules = result.stream().count();
            if (numberOfModules == 0L) {
                LOGGER.warn("No application modules detected!");
            } else {
                LOGGER.debug("Detected {} application modules: {}", (Object)numberOfModules, result.stream().map(ApplicationModule::getName).toList());
            }
            return result;
        }

        static {
            List factories = SpringFactoriesLoader.loadFactories(ApplicationModulesFactory.class, (ClassLoader)ApplicationModulesBootstrap.class.getClassLoader());
            BOOTSTRAP = !factories.isEmpty() ? (ApplicationModulesFactory)factories.get(0) : ApplicationModulesFactory.defaultFactory();
        }
    }

    @AutoConfiguration
    @ConditionalOnMissingClass(value={"com.tngtech.archunit.core.importer.ClassFileImporter"})
    static class ArchUnitRuntimeDependencyMissingConfiguration {
        private static final String DESCRIPTION = "The Spring Modulith runtime support requires ArchUnit to be on the runtime classpath. This might be caused by it declared as test scope dependency, as it usually is used in tests only.";
        private static final String SUGGESTED_ACTION = "Add ArchUnit to your project and ensure it configured to live in the runtime classpath at least.";

        ArchUnitRuntimeDependencyMissingConfiguration() {
            throw new MissingRuntimeDependency(DESCRIPTION, SUGGESTED_ACTION);
        }
    }
}

