/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.minidev.json.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.springframework.modulith.runtime.minidev.json.JSONValue;
import org.springframework.modulith.runtime.minidev.json.parser.JSONParserByteArray;
import org.springframework.modulith.runtime.minidev.json.parser.JSONParserInputStream;
import org.springframework.modulith.runtime.minidev.json.parser.JSONParserReader;
import org.springframework.modulith.runtime.minidev.json.parser.JSONParserString;
import org.springframework.modulith.runtime.minidev.json.parser.ParseException;
import org.springframework.modulith.runtime.minidev.json.writer.JsonReaderI;

public class JSONParser {
    public static final int ACCEPT_SIMPLE_QUOTE = 1;
    public static final int ACCEPT_NON_QUOTE = 2;
    public static final int ACCEPT_NAN = 4;
    public static final int IGNORE_CONTROL_CHAR = 8;
    public static final int USE_INTEGER_STORAGE = 16;
    public static final int ACCEPT_LEADING_ZERO = 32;
    public static final int ACCEPT_USELESS_COMMA = 64;
    public static final int USE_HI_PRECISION_FLOAT = 128;
    public static final int ACCEPT_TAILLING_DATA = 256;
    public static final int ACCEPT_TAILLING_SPACE = 512;
    public static final int REJECT_127_CHAR = 1024;
    public static final int BIG_DIGIT_UNRESTRICTED = 2048;
    public static final int LIMIT_JSON_DEPTH = 4096;
    public static final int MODE_PERMISSIVE = -1;
    public static final int MODE_RFC4627 = 4752;
    public static final int MODE_JSON_SIMPLE = 8128;
    public static final int MODE_STRICTEST = 5264;
    public static int DEFAULT_PERMISSIVE_MODE = System.getProperty("JSON_SMART_SIMPLE") != null ? 8128 : -1;
    private final int mode;
    private JSONParserInputStream pBinStream;
    private JSONParserByteArray pBytes;
    private JSONParserReader pStream;
    private JSONParserString pString;

    private JSONParserReader getPStream() {
        if (this.pStream == null) {
            this.pStream = new JSONParserReader(this.mode);
        }
        return this.pStream;
    }

    private JSONParserInputStream getPBinStream() {
        if (this.pBinStream == null) {
            this.pBinStream = new JSONParserInputStream(this.mode);
        }
        return this.pBinStream;
    }

    private JSONParserString getPString() {
        if (this.pString == null) {
            this.pString = new JSONParserString(this.mode);
        }
        return this.pString;
    }

    private JSONParserByteArray getPBytes() {
        if (this.pBytes == null) {
            this.pBytes = new JSONParserByteArray(this.mode);
        }
        return this.pBytes;
    }

    public JSONParser() {
        this.mode = DEFAULT_PERMISSIVE_MODE;
    }

    public JSONParser(int permissifMode) {
        this.mode = permissifMode;
    }

    public Object parse(byte[] in) throws ParseException {
        return this.getPBytes().parse(in);
    }

    public <T> T parse(byte[] in, JsonReaderI<T> mapper) throws ParseException {
        return this.getPBytes().parse(in, mapper);
    }

    public <T> T parse(byte[] in, Class<T> mapTo) throws ParseException {
        return this.getPBytes().parse(in, JSONValue.defaultReader.getMapper(mapTo));
    }

    public Object parse(InputStream in) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(in);
    }

    public <T> T parse(InputStream in, JsonReaderI<T> mapper) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(in, mapper);
    }

    public <T> T parse(InputStream in, Class<T> mapTo) throws ParseException, UnsupportedEncodingException {
        return this.getPBinStream().parse(in, JSONValue.defaultReader.getMapper(mapTo));
    }

    public Object parse(Reader in) throws ParseException {
        return this.getPStream().parse(in);
    }

    public <T> T parse(Reader in, JsonReaderI<T> mapper) throws ParseException {
        return this.getPStream().parse(in, mapper);
    }

    public <T> T parse(Reader in, Class<T> mapTo) throws ParseException {
        return this.getPStream().parse(in, JSONValue.defaultReader.getMapper(mapTo));
    }

    public Object parse(String in) throws ParseException {
        return this.getPString().parse(in);
    }

    public <T> T parse(String in, JsonReaderI<T> mapper) throws ParseException {
        return this.getPString().parse(in, mapper);
    }

    public <T> T parse(String in, Class<T> mapTo) throws ParseException {
        return this.getPString().parse(in, JSONValue.defaultReader.getMapper(mapTo));
    }
}

