/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleIdentifiers;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ApplicationModulesFactory;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.modulith.runtime.ApplicationRuntime;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleMetadata;
import org.springframework.modulith.runtime.autoconfigure.DefaultApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.MissingRuntimeDependency;
import org.springframework.modulith.runtime.autoconfigure.PrecomputedApplicationModuleInitializerInvoker;
import org.springframework.util.function.ThrowingSupplier;

@AutoConfiguration
class SpringModulithRuntimeAutoConfiguration {
    private static final AsyncTaskExecutor EXECUTOR = new SimpleAsyncTaskExecutor();

    SpringModulithRuntimeAutoConfiguration() {
    }

    @Bean
    @Lazy
    @Role(value=2)
    @ConditionalOnMissingBean(value={ApplicationRuntime.class})
    static ApplicationRuntime modulithsApplicationRuntime(ApplicationContext context) {
        return ApplicationRuntime.of(context);
    }

    @Bean
    @Lazy
    @Role(value=2)
    @ConditionalOnMissingBean
    static ApplicationModulesRuntime modulesRuntime(ApplicationRuntime runtime) {
        ThrowingSupplier modules = () -> (ApplicationModules)EXECUTOR.submit(() -> ApplicationModulesBootstrap.initializeApplicationModules(runtime.getMainApplicationClass())).get();
        return new ApplicationModulesRuntime((Supplier<ApplicationModules>)modules, runtime);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBean(value={ApplicationModuleInitializer.class})
    static ApplicationListener<ApplicationStartedEvent> applicationModuleInitializingListener(ApplicationModuleInitializerInvoker invoker, ObjectProvider<ApplicationModuleInitializer> initializers) {
        return __ -> invoker.invokeInitializers(initializers.stream());
    }

    @Bean
    @Role(value=2)
    static ApplicationModuleMetadata applicationModuleMetadata(@Value(value="classpath:META-INF/spring-modulith/application-modules.json") Resource metadata) {
        return ApplicationModuleMetadata.of(metadata);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBean(value={ApplicationModuleInitializer.class})
    static ApplicationModuleInitializerInvoker applicationModuleInitializerInvoker(ApplicationModuleMetadata metadata, ObjectProvider<ApplicationModulesRuntime> runtime) {
        return metadata.isPresent() ? new PrecomputedApplicationModuleInitializerInvoker(metadata) : new DefaultApplicationModuleInitializerInvoker(((ApplicationModulesRuntime)runtime.getObject()).get());
    }

    @Bean
    @Role(value=2)
    ApplicationModuleIdentifiers applicationModuleIdentifiers(ApplicationModuleMetadata metadata, ObjectProvider<ApplicationModulesRuntime> runtime) {
        return metadata.isPresent() ? ApplicationModuleIdentifiers.of(metadata.getIdentifiers()) : ApplicationModuleIdentifiers.of((ApplicationModules)((ApplicationModulesRuntime)runtime.getObject()).get());
    }

    private static class ApplicationModulesBootstrap {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesBootstrap.class);
        private static final ApplicationModulesFactory BOOTSTRAP;

        private ApplicationModulesBootstrap() {
        }

        static ApplicationModules initializeApplicationModules(Class<?> applicationMainClass) {
            LOGGER.debug("Obtaining Spring Modulith application modules\u2026");
            ApplicationModules result = BOOTSTRAP.of(applicationMainClass);
            long numberOfModules = result.stream().count();
            if (numberOfModules == 0L) {
                LOGGER.warn("No application modules detected!");
            } else {
                LOGGER.debug("Detected {} application modules: {}", (Object)numberOfModules, result.stream().map(ApplicationModule::getIdentifier).toList());
            }
            return result;
        }

        static {
            List factories = SpringFactoriesLoader.loadFactories(ApplicationModulesFactory.class, (ClassLoader)ApplicationModulesBootstrap.class.getClassLoader());
            BOOTSTRAP = !factories.isEmpty() ? (ApplicationModulesFactory)factories.get(0) : ApplicationModulesFactory.defaultFactory();
        }
    }

    @AutoConfiguration
    @ConditionalOnMissingClass(value={"com.tngtech.archunit.core.importer.ClassFileImporter"})
    static class ArchUnitRuntimeDependencyMissingConfiguration {
        private static final String DESCRIPTION = "The Spring Modulith runtime support requires ArchUnit to be on the runtime classpath. This might be caused by it declared as test scope dependency, as it usually is used in tests only.";
        private static final String SUGGESTED_ACTION = "Add ArchUnit to your project and ensure it configured to live in the runtime classpath at least.";

        ArchUnitRuntimeDependencyMissingConfiguration() {
            throw new MissingRuntimeDependency(DESCRIPTION, SUGGESTED_ACTION);
        }
    }
}

