/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal.path;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.modulith.runtime.jsonpath.Configuration;
import org.springframework.modulith.runtime.jsonpath.EvaluationListener;
import org.springframework.modulith.runtime.jsonpath.Option;
import org.springframework.modulith.runtime.jsonpath.PathNotFoundException;
import org.springframework.modulith.runtime.jsonpath.internal.EvaluationAbortException;
import org.springframework.modulith.runtime.jsonpath.internal.EvaluationContext;
import org.springframework.modulith.runtime.jsonpath.internal.Path;
import org.springframework.modulith.runtime.jsonpath.internal.PathRef;
import org.springframework.modulith.runtime.jsonpath.internal.Utils;
import org.springframework.modulith.runtime.jsonpath.internal.path.CompiledPath;
import org.springframework.modulith.runtime.jsonpath.internal.path.RootPathToken;
import org.springframework.modulith.runtime.jsonpath.spi.json.JsonProvider;

public class EvaluationContextImpl
implements EvaluationContext {
    private static final EvaluationAbortException ABORT_EVALUATION = new EvaluationAbortException();
    private final Configuration configuration;
    private final Object valueResult;
    private final Object pathResult;
    private final Path path;
    private final Object rootDocument;
    private final List<PathRef> updateOperations;
    private final HashMap<Path, Object> documentEvalCache = new HashMap();
    private final boolean forUpdate;
    private final boolean suppressExceptions;
    private int resultIndex = 0;

    public RootPathToken getRoot() {
        return ((CompiledPath)this.path).getRoot();
    }

    public EvaluationContextImpl(Path path, Object rootDocument, Configuration configuration, boolean forUpdate) {
        Utils.notNull(path, "path can not be null");
        Utils.notNull(rootDocument, "root can not be null");
        Utils.notNull(configuration, "configuration can not be null");
        this.forUpdate = forUpdate;
        this.path = path;
        this.rootDocument = rootDocument;
        this.configuration = configuration;
        this.valueResult = configuration.jsonProvider().createArray();
        this.pathResult = configuration.jsonProvider().createArray();
        this.updateOperations = new ArrayList<PathRef>();
        this.suppressExceptions = configuration.containsOption(Option.SUPPRESS_EXCEPTIONS);
    }

    public HashMap<Path, Object> documentEvalCache() {
        return this.documentEvalCache;
    }

    public boolean forUpdate() {
        return this.forUpdate;
    }

    public void addResult(String path, PathRef operation, Object model) {
        if (this.forUpdate) {
            this.updateOperations.add(operation);
        }
        this.configuration.jsonProvider().setArrayIndex(this.valueResult, this.resultIndex, model);
        this.configuration.jsonProvider().setArrayIndex(this.pathResult, this.resultIndex, path);
        ++this.resultIndex;
        if (!this.configuration().getEvaluationListeners().isEmpty()) {
            int idx = this.resultIndex - 1;
            for (EvaluationListener listener : this.configuration().getEvaluationListeners()) {
                EvaluationListener.EvaluationContinuation continuation = listener.resultFound(new FoundResultImpl(idx, path, model));
                if (EvaluationListener.EvaluationContinuation.ABORT != continuation) continue;
                throw ABORT_EVALUATION;
            }
        }
    }

    public JsonProvider jsonProvider() {
        return this.configuration.jsonProvider();
    }

    public Set<Option> options() {
        return this.configuration.getOptions();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public Object rootDocument() {
        return this.rootDocument;
    }

    @Override
    public Collection<PathRef> updateOperations() {
        Collections.sort(this.updateOperations);
        return Collections.unmodifiableCollection(this.updateOperations);
    }

    @Override
    public <T> T getValue() {
        return this.getValue(true);
    }

    @Override
    public <T> T getValue(boolean unwrap) {
        if (this.path.isDefinite()) {
            Object value;
            if (this.resultIndex == 0) {
                if (this.suppressExceptions) {
                    return null;
                }
                throw new PathNotFoundException("No results for path: " + this.path.toString());
            }
            int len = this.jsonProvider().length(this.valueResult);
            Object object = value = len > 0 ? this.jsonProvider().getArrayIndex(this.valueResult, len - 1) : null;
            if (value != null && unwrap) {
                value = this.jsonProvider().unwrap(value);
            }
            return (T)value;
        }
        return (T)this.valueResult;
    }

    @Override
    public <T> T getPath() {
        if (this.resultIndex == 0) {
            if (this.suppressExceptions) {
                return null;
            }
            throw new PathNotFoundException("No results for path: " + this.path.toString());
        }
        return (T)this.pathResult;
    }

    @Override
    public List<String> getPathList() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.resultIndex > 0) {
            Iterable<?> objects = this.configuration.jsonProvider().toIterable(this.pathResult);
            for (Object o : objects) {
                res.add((String)o);
            }
        }
        return res;
    }

    private static class FoundResultImpl
    implements EvaluationListener.FoundResult {
        private final int index;
        private final String path;
        private final Object result;

        private FoundResultImpl(int index, String path, Object result) {
            this.index = index;
            this.path = path;
            this.result = result;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public Object result() {
            return this.result;
        }
    }
}

