/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.flyway;

import java.util.List;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.springframework.boot.flyway.autoconfigure.FlywayMigrationStrategy;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.core.ApplicationModuleIdentifiers;
import org.springframework.util.Assert;

public class SpringModulithFlywayMigrationStrategy
implements FlywayMigrationStrategy {
    private final ApplicationModuleIdentifiers identifiers;

    public SpringModulithFlywayMigrationStrategy(ApplicationModuleIdentifiers identifiers) {
        Assert.notNull((Object)identifiers, (String)"ApplicationModuleIdentifiers must not be null!");
        this.identifiers = identifiers;
    }

    public void migrate(Flyway flyway) {
        new SpringModulithFlywayCustomizer(flyway).augment(this.identifiers).forEach(Flyway::migrate);
    }

    static class SpringModulithFlywayCustomizer {
        private final Flyway flyway;

        SpringModulithFlywayCustomizer(Flyway flyway) {
            this.flyway = flyway;
        }

        Stream<Flyway> augment(ApplicationModuleIdentifiers identifiers) {
            Configuration configuration = this.flyway.getConfiguration();
            Stream<Flyway> original = Stream.of(this.flyway);
            if (Stream.of(configuration.getLocations()).map(Location::toString).anyMatch(it -> it.endsWith("*"))) {
                return original;
            }
            Stream<Flyway> augmented = identifiers.stream().map(it -> this.augmentWithApplicationModule((ApplicationModuleIdentifier)it, configuration)).map(it -> SpringModulithFlywayCustomizer.withNewLocation(configuration, it));
            return Stream.concat(original, augmented);
        }

        private List<String> augmentWithApplicationModule(ApplicationModuleIdentifier identifier, Configuration configuration) {
            String asPath = identifier.toString().replace('.', '/');
            return Stream.of(configuration.getLocations()).map(Location::toString).map(it -> it.concat("/").concat(asPath)).toList();
        }

        private static Flyway withNewLocation(Configuration configuration, List<String> locations) {
            return Flyway.configure().configuration(configuration).locations((String[])locations.toArray(String[]::new)).load();
        }
    }
}

