/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.jsonpath.internal.filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.modulith.runtime.jsonpath.Predicate;
import org.springframework.modulith.runtime.jsonpath.internal.filter.Evaluator;
import org.springframework.modulith.runtime.jsonpath.internal.filter.EvaluatorFactory;
import org.springframework.modulith.runtime.jsonpath.internal.filter.ExpressionNode;
import org.springframework.modulith.runtime.jsonpath.internal.filter.RelationalOperator;
import org.springframework.modulith.runtime.jsonpath.internal.filter.ValueNode;

public class RelationalExpressionNode
extends ExpressionNode {
    private static final Logger logger = LoggerFactory.getLogger(RelationalExpressionNode.class);
    private final ValueNode left;
    private final RelationalOperator relationalOperator;
    private final ValueNode right;

    public RelationalExpressionNode(ValueNode left, RelationalOperator relationalOperator, ValueNode right) {
        this.left = left;
        this.relationalOperator = relationalOperator;
        this.right = right;
        logger.trace("ExpressionNode {}", (Object)this.toString());
    }

    public String toString() {
        if (this.relationalOperator == RelationalOperator.EXISTS) {
            return this.left.toString();
        }
        return this.left.toString() + " " + this.relationalOperator.toString() + " " + this.right.toString();
    }

    @Override
    public boolean apply(Predicate.PredicateContext ctx) {
        Evaluator evaluator;
        ValueNode l = this.left;
        ValueNode r = this.right;
        if (this.left.isPathNode()) {
            l = this.left.asPathNode().evaluate(ctx);
        }
        if (this.right.isPathNode()) {
            r = this.right.asPathNode().evaluate(ctx);
        }
        if ((evaluator = EvaluatorFactory.createEvaluator(this.relationalOperator)) != null) {
            return evaluator.evaluate(l, r, ctx);
        }
        return false;
    }
}

