/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.JavaPackage;
import org.springframework.modulith.test.ApplicationModuleTest;
import org.springframework.util.function.SingletonSupplier;

public class ModuleTestExecution
implements Iterable<ApplicationModule> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleTestExecution.class);
    private static Map<Class<?>, Class<?>> MODULITH_TYPES = new HashMap();
    private static Map<Key, ModuleTestExecution> EXECUTIONS = new HashMap<Key, ModuleTestExecution>();
    private final Key key;
    private final ApplicationModuleTest.BootstrapMode bootstrapMode;
    private final ApplicationModule module;
    private final ApplicationModules modules;
    private final List<ApplicationModule> extraIncludes;
    private final Supplier<List<JavaPackage>> basePackages;
    private final Supplier<List<ApplicationModule>> dependencies;

    private ModuleTestExecution(ApplicationModuleTest annotation, ApplicationModules modules, ApplicationModule module) {
        this.key = new Key(module.getBasePackage().getName(), annotation);
        this.modules = modules;
        this.bootstrapMode = annotation.mode();
        this.module = module;
        this.extraIncludes = ModuleTestExecution.getExtraModules(annotation, modules).toList();
        this.basePackages = SingletonSupplier.of(() -> {
            Stream moduleBasePackages = module.getBootstrapBasePackages(modules, this.bootstrapMode.getDepth());
            Stream<JavaPackage> sharedBasePackages = modules.getSharedModules().stream().map(it -> it.getBasePackage());
            Stream<JavaPackage> extraPackages = this.extraIncludes.stream().map(ApplicationModule::getBasePackage);
            Stream<JavaPackage> intermediate = Stream.concat(moduleBasePackages, extraPackages);
            return Stream.concat(intermediate, sharedBasePackages).distinct().toList();
        });
        this.dependencies = SingletonSupplier.of(() -> {
            Stream bootstrapDependencies = module.getBootstrapDependencies(modules, this.bootstrapMode.getDepth());
            return Stream.concat(bootstrapDependencies, this.extraIncludes.stream()).distinct().toList();
        });
        if (annotation.verifyAutomatically()) {
            this.verify();
        }
    }

    public static Supplier<ModuleTestExecution> of(Class<?> type) {
        return () -> {
            ApplicationModuleTest annotation = (ApplicationModuleTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, ApplicationModuleTest.class);
            String packageName = type.getPackage().getName();
            Class modulithType = MODULITH_TYPES.computeIfAbsent(type, it -> new AnnotatedClassFinder(SpringBootApplication.class).findFromPackage(packageName));
            ApplicationModules modules = ApplicationModules.of((Class)modulithType);
            ApplicationModule module = (ApplicationModule)modules.getModuleForPackage(packageName).orElseThrow(() -> new IllegalStateException(String.format("Package %s is not part of any module!", packageName)));
            return EXECUTIONS.computeIfAbsent(new Key(module.getBasePackage().getName(), annotation), it -> new ModuleTestExecution(annotation, modules, module));
        };
    }

    public Stream<String> getBasePackages() {
        return this.basePackages.get().stream().map(JavaPackage::getName);
    }

    public boolean includes(String className) {
        boolean result;
        boolean bl = result = this.modules.withinRootPackages(className) || this.basePackages.get().stream().anyMatch(it -> it.contains(className));
        if (result) {
            LOGGER.trace("Including class {}.", (Object)className);
        }
        return !result;
    }

    public List<ApplicationModule> getDependencies() {
        return this.dependencies.get();
    }

    public void verify() {
        this.modules.verify();
    }

    public void verifyModule() {
        this.module.verifyDependencies(this.modules);
    }

    public ApplicationModuleTest.BootstrapMode getBootstrapMode() {
        return this.bootstrapMode;
    }

    public ApplicationModule getModule() {
        return this.module;
    }

    public ApplicationModules getModules() {
        return this.modules;
    }

    public List<ApplicationModule> getExtraIncludes() {
        return this.extraIncludes;
    }

    @Override
    public Iterator<ApplicationModule> iterator() {
        return this.modules.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleTestExecution)) {
            return false;
        }
        ModuleTestExecution that = (ModuleTestExecution)obj;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    private static Stream<ApplicationModule> getExtraModules(ApplicationModuleTest annotation, ApplicationModules modules) {
        return Arrays.stream(annotation.extraIncludes()).map(arg_0 -> ((ApplicationModules)modules).getModuleByName(arg_0)).flatMap(it -> it.map(Stream::of).orElseGet(Stream::empty));
    }

    private record Key(String moduleBasePackage, ApplicationModuleTest annotation) {
    }
}

