/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.JavaPackage;
import org.springframework.modulith.test.ApplicationModuleTest;
import org.springframework.modulith.test.DefaultPublishedEvents;
import org.springframework.modulith.test.ModuleTestExecution;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.Assert;

class ModuleContextCustomizerFactory
implements ContextCustomizerFactory {
    ModuleContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        TestContextAnnotationUtils.AnnotationDescriptor moduleTest = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ApplicationModuleTest.class);
        return moduleTest == null ? null : new ModuleContextCustomizer(moduleTest.getRootDeclaringClass());
    }

    static class ModuleContextCustomizer
    implements ContextCustomizer {
        private static final Logger LOGGER = LoggerFactory.getLogger(ModuleContextCustomizer.class);
        private final Supplier<ModuleTestExecution> execution;
        private final Class<?> source;

        ModuleContextCustomizer(Class<?> testClass) {
            this.execution = ModuleTestExecution.of(testClass);
            this.source = testClass;
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            ModuleTestExecution testExecution = this.execution.get();
            ModuleContextCustomizer.logModules(testExecution);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            beanFactory.registerSingleton(ModuleTestExecution.class.getName(), (Object)testExecution);
            beanFactory.registerSingleton(ModuleTestExecutionBeanDefinitionSelector.class.getName(), (Object)new ModuleTestExecutionBeanDefinitionSelector(testExecution));
            DefaultPublishedEvents events = new DefaultPublishedEvents();
            beanFactory.registerSingleton(events.getClass().getName(), (Object)events);
            context.addApplicationListener((ApplicationListener)events);
        }

        private static void logModules(ModuleTestExecution execution) {
            List<ApplicationModule> dependencies;
            Set sharedModules;
            ApplicationModule module = execution.getModule();
            ApplicationModules modules = execution.getModules();
            String moduleName = module.getDisplayName();
            String bootstrapMode = execution.getBootstrapMode().name();
            String message = "Bootstrapping @%s for %s in mode %s (%s)\u2026".formatted(ApplicationModuleTest.class.getName(), moduleName, bootstrapMode, modules.getSource());
            LOGGER.info(message);
            LOGGER.info("");
            Arrays.stream(module.toString(modules).split("\n")).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            List<ApplicationModule> extraIncludes = execution.getExtraIncludes();
            if (!extraIncludes.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Extra includes:");
                LOGGER.info("> " + extraIncludes.stream().map(ApplicationModule::getName).collect(Collectors.joining(", ")));
            }
            if (!(sharedModules = modules.getSharedModules()).isEmpty()) {
                ModuleContextCustomizer.logHeadline("Shared modules:");
                LOGGER.info("> " + sharedModules.stream().map(ApplicationModule::getName).collect(Collectors.joining(", ")));
            }
            if (!(dependencies = execution.getDependencies()).isEmpty() || !sharedModules.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Included dependencies:");
                Stream<ApplicationModule> dependenciesPlusMissingSharedOnes = Stream.concat(dependencies.stream(), sharedModules.stream().filter(it -> !dependencies.contains(it)));
                dependenciesPlusMissingSharedOnes.map(it -> it.toString(modules)).forEach(it -> {
                    LOGGER.info("");
                    Arrays.stream(it.split("\n")).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
                });
            }
            LOGGER.info("");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleContextCustomizer)) {
                return false;
            }
            ModuleContextCustomizer that = (ModuleContextCustomizer)obj;
            return Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hashCode(this.source);
        }

        private static void logHeadline(String headline) {
            ModuleContextCustomizer.logHeadline(headline, () -> {});
        }

        private static void logHeadline(String headline, Runnable additional) {
            LOGGER.info("");
            LOGGER.info(headline);
            additional.run();
        }
    }

    private static class ModuleTestExecutionBeanDefinitionSelector
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(ModuleTestExecutionBeanDefinitionSelector.class);
        private final ModuleTestExecution execution;

        private ModuleTestExecutionBeanDefinitionSelector(ModuleTestExecution execution) {
            Assert.notNull((Object)execution, (String)"ModuleTestExecution must not be null!");
            this.execution = execution;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (!(registry instanceof ConfigurableListableBeanFactory)) {
                return;
            }
            ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)registry;
            ApplicationModules modules = this.execution.getModules();
            for (String name : registry.getBeanDefinitionNames()) {
                Class type = factory.getType(name, false);
                Optional<ApplicationModule> module = modules.getModuleByType(type).filter(Predicate.not(ApplicationModule::isRootModule));
                if (module.isEmpty()) continue;
                List<String> packagesIncludedInTestRun = this.execution.getBasePackages().toList();
                if (module.map(ApplicationModule::getBasePackage).map(JavaPackage::getName).filter(packagesIncludedInTestRun::contains).isPresent()) continue;
                LOGGER.trace("Dropping bean definition {} for type {} as it is not included in an application module to be bootstrapped!", (Object)name, (Object)type.getName());
                registry.removeBeanDefinition(name);
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

