/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.modulith.test.ModuleTestExecution;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={AutoConfigurationAndEntityScanPackageCustomizer.class})
@AutoConfigureOrder(value=-2147483648)
class ModuleTestAutoConfiguration {
    static final String AUTOCONFIG_PACKAGES = "org.springframework.boot.autoconfigure.AutoConfigurationPackages";
    static final String ENTITY_SCAN_PACKAGE = "org.springframework.boot.autoconfigure.domain.EntityScanPackages";

    ModuleTestAutoConfiguration() {
    }

    static class AutoConfigurationAndEntityScanPackageCustomizer
    implements ImportBeanDefinitionRegistrar {
        private static final Logger LOGGER = LoggerFactory.getLogger(AutoConfigurationAndEntityScanPackageCustomizer.class);

        AutoConfigurationAndEntityScanPackageCustomizer() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            ModuleTestExecution execution = (ModuleTestExecution)((BeanFactory)registry).getBean(ModuleTestExecution.class);
            List<String> basePackages = execution.getBasePackages().toList();
            LOGGER.info("Re-configuring auto-configuration and entity scan packages to: {}.", (Object)StringUtils.collectionToDelimitedString(basePackages, (String)", "));
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.AUTOCONFIG_PACKAGES, basePackages);
            this.setBasePackagesOn(registry, ModuleTestAutoConfiguration.ENTITY_SCAN_PACKAGE, basePackages);
        }

        void setBasePackagesOn(BeanDefinitionRegistry registry, String beanName, List<String> packages) {
            if (!registry.containsBeanDefinition(beanName)) {
                return;
            }
            ArrayList<String> packagesToSet = new ArrayList<String>(packages);
            BeanDefinition definition = registry.getBeanDefinition(beanName);
            ConstructorArgumentValues.ValueHolder holder = definition.getConstructorArgumentValues().getArgumentValue(0, String[].class);
            if (holder != null) {
                Arrays.stream((String[])holder.getValue()).filter(it -> it.startsWith("org.springframework.modulith")).forEach(packagesToSet::add);
            }
            definition.getConstructorArgumentValues().addIndexedArgumentValue(0, packagesToSet.toArray(String[]::new));
        }
    }
}

