/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.AnnotatedClassFinder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ApplicationModulesFactory;
import org.springframework.modulith.core.JavaPackage;
import org.springframework.modulith.core.PackageName;
import org.springframework.modulith.test.ApplicationModuleTest;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.SingletonSupplier;

public class ModuleTestExecution
implements Iterable<ApplicationModule> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleTestExecution.class);
    private static final ApplicationModulesFactory BOOTSTRAP;
    private static final Map<Class<?>, Class<?>> MODULITH_TYPES;
    private static final Map<Key, ModuleTestExecution> EXECUTIONS;
    private final Key key;
    private final ApplicationModuleTest.BootstrapMode bootstrapMode;
    private final ApplicationModule module;
    private final ApplicationModules modules;
    private final List<ApplicationModule> extraIncludes;
    private final Supplier<List<JavaPackage>> basePackages;
    private final Supplier<List<ApplicationModule>> dependencies;

    private ModuleTestExecution(ApplicationModuleTest annotation, ApplicationModules modules, ApplicationModule module) {
        this.key = new Key(module.getBasePackage().getName(), annotation);
        this.modules = modules;
        this.bootstrapMode = annotation.mode();
        this.module = module;
        this.extraIncludes = ModuleTestExecution.getExtraModules(annotation, modules).toList();
        this.basePackages = SingletonSupplier.of(() -> {
            Stream moduleBasePackages = module.getBootstrapBasePackages(modules, this.bootstrapMode.getDepth());
            Stream<JavaPackage> sharedBasePackages = modules.getSharedModules().stream().map(it -> it.getBasePackage());
            Stream<JavaPackage> extraPackages = this.extraIncludes.stream().map(ApplicationModule::getBasePackage);
            Stream<JavaPackage> intermediate = Stream.concat(moduleBasePackages, extraPackages);
            return Stream.concat(intermediate, sharedBasePackages).distinct().toList();
        });
        this.dependencies = SingletonSupplier.of(() -> {
            Stream bootstrapDependencies = module.getBootstrapDependencies(modules, this.bootstrapMode.getDepth());
            return Stream.concat(bootstrapDependencies, this.extraIncludes.stream()).distinct().toList();
        });
        if (annotation.verifyAutomatically()) {
            this.verify();
        }
    }

    public static Supplier<ModuleTestExecution> of(Class<?> type) {
        return SingletonSupplier.of(() -> {
            ApplicationModuleTest annotation = (ApplicationModuleTest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)type, ApplicationModuleTest.class);
            if (annotation == null) {
                throw new IllegalStateException("%s not found on %s!".formatted(ApplicationModuleTest.class.getName(), type.getName()));
            }
            String packageName = PackageName.ofType((Class)type).toString();
            ApplicationModules modules = BOOTSTRAP.of(ModuleTestExecution.findSpringBootApplicationByClasses(annotation, type));
            String moduleName = annotation.module();
            ApplicationModule module = StringUtils.hasText((String)moduleName) ? (ApplicationModule)modules.getModuleByName(moduleName).orElseThrow(() -> new IllegalStateException("Unable to find module %s!".formatted(moduleName))) : (ApplicationModule)modules.getModuleForPackage(packageName).orElseThrow(() -> new IllegalStateException("Package %s is not part of any module!".formatted(packageName)));
            return EXECUTIONS.computeIfAbsent(new Key(module.getBasePackage().getName(), annotation), it -> new ModuleTestExecution(annotation, modules, module));
        });
    }

    public Stream<String> getBasePackages() {
        return this.basePackages.get().stream().map(JavaPackage::getName);
    }

    public boolean includes(String className) {
        boolean result = this.isLocatedInRootPackageOrContainedInBasePackages(className);
        if (result) {
            LOGGER.trace("Including class {}.", (Object)className);
        }
        return !result;
    }

    public List<ApplicationModule> getDependencies() {
        return this.dependencies.get();
    }

    public void verify() {
        this.modules.verify();
    }

    public void verifyModule() {
        this.module.verifyDependencies(this.modules);
    }

    public ApplicationModuleTest.BootstrapMode getBootstrapMode() {
        return this.bootstrapMode;
    }

    public ApplicationModule getModule() {
        return this.module;
    }

    public ApplicationModules getModules() {
        return this.modules;
    }

    public List<ApplicationModule> getExtraIncludes() {
        return this.extraIncludes;
    }

    @Override
    public Iterator<ApplicationModule> iterator() {
        return this.modules.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleTestExecution)) {
            return false;
        }
        ModuleTestExecution that = (ModuleTestExecution)obj;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    private boolean isLocatedInRootPackageOrContainedInBasePackages(String className) {
        if (this.modules.withinRootPackages(className)) {
            return true;
        }
        PackageName candidate = PackageName.ofType((String)className);
        return this.basePackages.get().stream().map(JavaPackage::getPackageName).anyMatch(it -> it.contains(candidate));
    }

    private static Stream<ApplicationModule> getExtraModules(ApplicationModuleTest annotation, ApplicationModules modules) {
        return Arrays.stream(annotation.extraIncludes()).map(arg_0 -> ((ApplicationModules)modules).getModuleByName(arg_0)).flatMap(Optional::stream);
    }

    private static Class<?> findSpringBootApplicationByClasses(ApplicationModuleTest annotation, Class<?> testClass) {
        Class[] types = (Class[])ObjectUtils.addObjectToArray((Object[])annotation.classes(), testClass);
        return Arrays.stream(types).map(ModuleTestExecution::lookupSpringBootApplicationAnnotation).findFirst().orElseThrow(() -> new IllegalStateException("Couldn't find @SpringBootApplication traversing %s.".formatted(Arrays.stream(types).map(Class::getName).collect(Collectors.joining(", ")))));
    }

    private static Class<?> lookupSpringBootApplicationAnnotation(Class<?> clazz) {
        return MODULITH_TYPES.computeIfAbsent(clazz, it -> new AnnotatedClassFinder(SpringBootApplication.class).findFromClass(clazz));
    }

    static {
        MODULITH_TYPES = new ConcurrentHashMap();
        EXECUTIONS = new ConcurrentHashMap<Key, ModuleTestExecution>();
        List factories = SpringFactoriesLoader.loadFactories(ApplicationModulesFactory.class, (ClassLoader)ModuleTestExecution.class.getClassLoader());
        BOOTSTRAP = !factories.isEmpty() ? (ApplicationModulesFactory)factories.get(0) : ApplicationModulesFactory.defaultFactory();
    }

    private record Key(String moduleBasePackage, ApplicationModuleTest annotation) {
    }
}

