/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.modulith.test.DefaultPublishedEvents;
import org.springframework.modulith.test.TypedEvents;
import org.springframework.util.Assert;

public interface PublishedEvents
extends TypedEvents {
    public static PublishedEvents of(Object ... events) {
        return PublishedEvents.of(Arrays.asList(events));
    }

    public static PublishedEvents of(Collection<? extends Object> events) {
        Assert.notNull(events, (String)"Events must not be null!");
        return new DefaultPublishedEvents(events);
    }

    @Override
    public <T> TypedPublishedEvents<T> ofType(Class<T> var1);

    public static interface TypedPublishedEvents<T>
    extends Iterable<T>,
    TypedEvents {
        default public <S extends T> TypedPublishedEvents<S> ofSubType(Class<S> subType) {
            return this.ofType(subType);
        }

        public <S> TypedPublishedEvents<S> ofType(Class<S> var1);

        public TypedPublishedEvents<T> matching(Predicate<? super T> var1);

        public <S> TypedPublishedEvents<T> matching(Function<T, S> var1, Predicate<? super S> var2);

        public <S> TypedPublishedEvents<T> matching(Function<T, S> var1, @Nullable S var2);

        @Deprecated(forRemoval=true, since="0.3")
        default public <S> TypedPublishedEvents<T> matchingMapped(Function<T, S> mapper, Predicate<? super S> predicate) {
            return this.matching(mapper, (S)predicate);
        }
    }
}

