/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.mock;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.springframework.osgi.mock.MockBundle;

public class MockServiceReference
implements ServiceReference {
    private Bundle bundle;
    private static long GLOBAL_SERVICE_ID = System.currentTimeMillis();
    private long serviceId;
    private Dictionary properties;
    private String[] objectClass = new String[]{Object.class.getName()};

    public MockServiceReference() {
        this(null, null, null);
    }

    public MockServiceReference(Bundle bundle) {
        this(bundle, null, null);
    }

    public MockServiceReference(String[] classes) {
        this(null, null, null, classes);
    }

    public MockServiceReference(Bundle bundle, String[] classes) {
        this(bundle, null, null, classes);
    }

    public MockServiceReference(ServiceRegistration registration) {
        this(null, null, registration);
    }

    public MockServiceReference(Bundle bundle, Dictionary properties, ServiceRegistration registration) {
        this(bundle, properties, registration, null);
    }

    public MockServiceReference(Bundle bundle, Dictionary properties, ServiceRegistration registration, String[] classes) {
        this.bundle = bundle == null ? new MockBundle() : bundle;
        Dictionary dictionary = this.properties = properties == null ? new Hashtable() : properties;
        if (classes != null && classes.length > 0) {
            this.objectClass = classes;
        }
        this.addMandatoryProperties(this.properties);
    }

    private void addMandatoryProperties(Dictionary dict) {
        Object ranking;
        Object id = dict.get("service.id");
        if (id == null || !(id instanceof Long)) {
            dict.put("service.id", new Long(GLOBAL_SERVICE_ID++));
        }
        if (dict.get("objectClass") == null) {
            dict.put("objectClass", this.objectClass);
        }
        if ((ranking = dict.get("service.ranking")) == null || !(ranking instanceof Integer)) {
            dict.put("service.ranking", new Integer(0));
        }
        this.serviceId = (Long)dict.get("service.id");
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String[] getPropertyKeys() {
        String[] keys = new String[this.properties.size()];
        Enumeration ks = this.properties.keys();
        for (int i = 0; i < keys.length && ks.hasMoreElements(); ++i) {
            keys[i] = (String)ks.nextElement();
        }
        return keys;
    }

    public Bundle[] getUsingBundles() {
        return new Bundle[0];
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        return false;
    }

    public void setProperties(Dictionary properties) {
        if (properties != null) {
            properties.put("service.id", this.properties.get("service.id"));
            properties.put("objectClass", this.properties.get("objectClass"));
            if (properties.get("service.ranking") == null) {
                properties.put("service.ranking", this.properties.get("service.ranking"));
            }
            this.properties = properties;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MockServiceReference) {
            return this.hashCode() == ((MockServiceReference)obj).hashCode();
        }
        return false;
    }

    public int hashCode() {
        return MockServiceReference.class.hashCode() * 13 + (int)this.serviceId;
    }

    public String toString() {
        return "mock service reference [owning bundle id=" + this.bundle.hashCode() + "|props : " + this.properties + "]";
    }
}

