/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.cache.provider.caffeine;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.pulsar.cache.provider.CacheProvider;
import org.springframework.pulsar.shade.com.github.benmanes.caffeine.cache.Cache;

public class CaffeineCacheProvider<K, V>
implements CacheProvider<K, V> {
    private final Cache<K, V> cache;

    public CaffeineCacheProvider(Cache<K, V> cache) {
        this.cache = cache;
    }

    public V getOrCreateIfAbsent(K cacheKey, Function<K, V> createEntryFunction) {
        return this.cache.get(cacheKey, createEntryFunction);
    }

    public Map<K, V> asMap() {
        return this.cache.asMap();
    }

    public void invalidateAll(BiConsumer<K, V> onInvalidateEntry) {
        this.cache.asMap().forEach((cacheKey, cacheEntry) -> {
            this.cache.invalidate(cacheKey);
            onInvalidateEntry.accept(cacheKey, cacheEntry);
        });
    }
}

