/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.pulsar.client.api.Schema;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.reactive.config.AbstractReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerContainerFactory;
import org.springframework.pulsar.reactive.config.ReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.listener.DefaultReactivePulsarMessageListenerContainer;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;
import org.springframework.pulsar.support.JavaUtils;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultReactivePulsarListenerContainerFactory<T>
implements ReactivePulsarListenerContainerFactory<T> {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    private final ReactivePulsarConsumerFactory<T> consumerFactory;
    private final ReactivePulsarContainerProperties<T> containerProperties;
    private Boolean autoStartup;
    private MessageConverter messageConverter;
    private Boolean fluxListener;

    public DefaultReactivePulsarListenerContainerFactory(ReactivePulsarConsumerFactory<T> consumerFactory, ReactivePulsarContainerProperties<T> containerProperties) {
        this.consumerFactory = consumerFactory;
        this.containerProperties = containerProperties;
    }

    protected ReactivePulsarConsumerFactory<T> getConsumerFactory() {
        return this.consumerFactory;
    }

    public ReactivePulsarContainerProperties<T> getContainerProperties() {
        return this.containerProperties;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setFluxListener(Boolean fluxListener) {
        this.fluxListener = fluxListener;
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createContainerInstance(ReactivePulsarListenerEndpoint<T> endpoint) {
        ReactivePulsarContainerProperties properties = new ReactivePulsarContainerProperties();
        properties.setSchemaResolver(this.getContainerProperties().getSchemaResolver());
        properties.setTopicResolver(this.getContainerProperties().getTopicResolver());
        if (!CollectionUtils.isEmpty((Collection)endpoint.getTopics())) {
            properties.setTopics(endpoint.getTopics());
        }
        if (StringUtils.hasText((String)endpoint.getTopicPattern())) {
            properties.setTopicsPattern(endpoint.getTopicPattern());
        }
        if (StringUtils.hasText((String)endpoint.getSubscriptionName())) {
            properties.setSubscriptionName(endpoint.getSubscriptionName());
        }
        if (endpoint.getSubscriptionType() != null) {
            properties.setSubscriptionType(endpoint.getSubscriptionType());
        } else {
            properties.setSubscriptionType(this.containerProperties.getSubscriptionType());
        }
        if (endpoint.getSchemaType() != null) {
            properties.setSchemaType(endpoint.getSchemaType());
        } else {
            properties.setSchemaType(this.containerProperties.getSchemaType());
        }
        if (properties.getSchema() == null) {
            properties.setSchema(Schema.BYTES);
        }
        if (endpoint.getConcurrency() != null) {
            properties.setConcurrency(endpoint.getConcurrency());
        } else {
            properties.setConcurrency(this.containerProperties.getConcurrency());
        }
        if (endpoint.getUseKeyOrderedProcessing() != null) {
            properties.setUseKeyOrderedProcessing(endpoint.getUseKeyOrderedProcessing());
        } else {
            properties.setUseKeyOrderedProcessing(this.containerProperties.isUseKeyOrderedProcessing());
        }
        return new DefaultReactivePulsarMessageListenerContainer<T>(this.getConsumerFactory(), properties);
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createListenerContainer(ReactivePulsarListenerEndpoint<T> endpoint) {
        DefaultReactivePulsarMessageListenerContainer<T> instance = this.createContainerInstance(endpoint);
        if (endpoint instanceof AbstractReactivePulsarListenerEndpoint) {
            this.configureEndpoint((AbstractReactivePulsarListenerEndpoint)endpoint);
        }
        endpoint.setupListenerContainer(instance, this.messageConverter);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    private void configureEndpoint(AbstractReactivePulsarListenerEndpoint<T> aplEndpoint) {
        if (aplEndpoint.getFluxListener() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.fluxListener, aplEndpoint::setFluxListener);
        }
    }

    public DefaultReactivePulsarMessageListenerContainer<T> createContainer(final String ... topics) {
        ReactivePulsarListenerEndpoint endpoint = new ReactivePulsarListenerEndpoint<T>(){

            public List<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        DefaultReactivePulsarMessageListenerContainer<T> container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        return container;
    }

    private void initializeContainer(DefaultReactivePulsarMessageListenerContainer<T> instance, ReactivePulsarListenerEndpoint<T> endpoint) {
        Boolean autoStart = endpoint.getAutoStartup();
        if (autoStart != null) {
            instance.setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            instance.setAutoStartup(this.autoStartup);
        }
    }
}

