/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.core;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumer;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerBuilder;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.reactive.core.ReactiveMessageConsumerBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultReactivePulsarConsumerFactory<T>
implements ReactivePulsarConsumerFactory<T> {
    private final ReactivePulsarClient reactivePulsarClient;
    @Nullable
    private final List<ReactiveMessageConsumerBuilderCustomizer<T>> defaultConfigCustomizers;

    public DefaultReactivePulsarConsumerFactory(ReactivePulsarClient reactivePulsarClient, List<ReactiveMessageConsumerBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.reactivePulsarClient = reactivePulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    @Override
    public ReactiveMessageConsumer<T> createConsumer(Schema<T> schema) {
        return this.createConsumer(schema, Collections.emptyList());
    }

    @Override
    public ReactiveMessageConsumer<T> createConsumer(Schema<T> schema, List<ReactiveMessageConsumerBuilderCustomizer<T>> customizers) {
        ReactiveMessageConsumerBuilder consumerBuilder = this.reactivePulsarClient.messageConsumer(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(consumerBuilder));
        }
        return consumerBuilder.build();
    }
}

