/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerBuilder;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.reactive.config.AbstractReactivePulsarListenerEndpoint;
import org.springframework.pulsar.reactive.core.ReactiveMessageConsumerBuilderCustomizer;
import org.springframework.pulsar.reactive.listener.DefaultReactivePulsarMessageListenerContainer;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;
import org.springframework.pulsar.reactive.listener.ReactivePulsarMessageListenerContainer;
import org.springframework.pulsar.reactive.listener.adapter.PulsarReactiveMessagingMessageListenerAdapter;
import org.springframework.pulsar.reactive.listener.adapter.PulsarReactiveOneByOneMessagingMessageListenerAdapter;
import org.springframework.pulsar.reactive.listener.adapter.PulsarReactiveStreamingMessagingMessageListenerAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;

public class MethodReactivePulsarListenerEndpoint<V>
extends AbstractReactivePulsarListenerEndpoint<V> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private Object bean;
    private Method method;
    private ObjectMapper objectMapper;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private SmartMessageConverter messagingConverter;
    private ReactiveMessageConsumerBuilderCustomizer<V> consumerCustomizer;
    private DeadLetterPolicy deadLetterPolicy;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    @Override
    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageHandler(ReactivePulsarMessageListenerContainer<V> container, @Nullable MessageConverter messageConverter) {
        boolean hasTopicInfo;
        SchemaInfo schemaInfo;
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        AbstractPulsarMessageToSpringMessageAdapter<V> messageListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(messageListener);
        messageListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.getInvokerHandlerMethod().getMethodParameters();
        MethodParameter messageParameter = null;
        Optional<MethodParameter> parameter = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) || !methodParameter1.getParameterType().equals(Acknowledgement.class) || !methodParameter1.hasParameterAnnotation(Header.class)).findFirst();
        long count = Arrays.stream(methodParameters).filter(methodParameter1 -> !methodParameter1.getParameterType().equals(Consumer.class) && !methodParameter1.getParameterType().equals(Acknowledgement.class) && !methodParameter1.hasParameterAnnotation(Header.class)).count();
        Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"More than 1 expected payload types found");
        if (parameter.isPresent()) {
            messageParameter = parameter.get();
        }
        DefaultReactivePulsarMessageListenerContainer containerInstance = (DefaultReactivePulsarMessageListenerContainer)container;
        ReactivePulsarContainerProperties pulsarContainerProperties = containerInstance.getContainerProperties();
        SchemaResolver schemaResolver = pulsarContainerProperties.getSchemaResolver();
        SchemaType schemaType = pulsarContainerProperties.getSchemaType();
        ResolvableType messageType = this.resolvableType(messageParameter);
        schemaResolver.resolveSchema(schemaType, messageType).ifResolvedOrElse(pulsarContainerProperties::setSchema, ex -> this.logger.warn(() -> "Failed to resolve schema for type %s - will default to BYTES (due to: %s)".formatted(schemaType, ex.getMessage())));
        if (pulsarContainerProperties.getSchema() != null && (schemaInfo = pulsarContainerProperties.getSchema().getSchemaInfo()) != null) {
            pulsarContainerProperties.setSchemaType(schemaInfo.getType());
        }
        TopicResolver topicResolver = pulsarContainerProperties.getTopicResolver();
        boolean bl = hasTopicInfo = pulsarContainerProperties.getTopicsPattern() != null || !ObjectUtils.isEmpty(pulsarContainerProperties.getTopics());
        if (!hasTopicInfo) {
            topicResolver.resolveTopic(null, messageType.getRawClass(), () -> null).ifResolved(topic -> pulsarContainerProperties.setTopics(Collections.singleton(topic)));
        }
        ReactiveMessageConsumerBuilderCustomizer customizer1 = b -> b.deadLetterPolicy(this.deadLetterPolicy);
        container.setConsumerCustomizer((ReactiveMessageConsumerBuilder<T> b) -> {
            if (this.consumerCustomizer != null) {
                this.consumerCustomizer.customize(b);
            }
            customizer1.customize(b);
        });
        return messageListener;
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (resolvableType.getRawClass() != null && (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass()))) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(Flux.class) || rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(AbstractPulsarMessageToSpringMessageAdapter<V> messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        PulsarReactiveMessagingMessageListenerAdapter listener = this.isFluxListener() ? new PulsarReactiveStreamingMessagingMessageListenerAdapter(this.bean, this.method) : new PulsarReactiveOneByOneMessagingMessageListenerAdapter(this.bean, this.method);
        if (messageConverter instanceof PulsarMessageConverter) {
            PulsarMessageConverter pulsarMessageConverter = (PulsarMessageConverter)messageConverter;
            listener.setMessageConverter(pulsarMessageConverter);
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if (this.objectMapper != null) {
            listener.setObjectMapper(this.objectMapper);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public ReactiveMessageConsumerBuilderCustomizer<V> getConsumerCustomizer() {
        return this.consumerCustomizer;
    }

    public void setConsumerCustomizer(ReactiveMessageConsumerBuilderCustomizer<V> consumerCustomizer) {
        this.consumerCustomizer = consumerCustomizer;
    }
}

