/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.reactive.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumer;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerBuilder;
import org.apache.pulsar.reactive.client.api.ReactivePulsarClient;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarTopicBuilder;
import org.springframework.pulsar.reactive.core.ReactiveMessageConsumerBuilderCustomizer;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.util.CollectionUtils;

public class DefaultReactivePulsarConsumerFactory<T>
implements ReactivePulsarConsumerFactory<T> {
    private final ReactivePulsarClient reactivePulsarClient;
    @Nullable
    private final List<ReactiveMessageConsumerBuilderCustomizer<T>> defaultConfigCustomizers;
    @Nullable
    private PulsarTopicBuilder topicBuilder;

    public DefaultReactivePulsarConsumerFactory(ReactivePulsarClient reactivePulsarClient, List<ReactiveMessageConsumerBuilderCustomizer<T>> defaultConfigCustomizers) {
        this.reactivePulsarClient = reactivePulsarClient;
        this.defaultConfigCustomizers = defaultConfigCustomizers;
    }

    public void setTopicBuilder(@Nullable PulsarTopicBuilder topicBuilder) {
        this.topicBuilder = topicBuilder;
    }

    @Override
    public ReactiveMessageConsumer<T> createConsumer(Schema<T> schema) {
        return this.createConsumer(schema, Collections.emptyList());
    }

    @Override
    public ReactiveMessageConsumer<T> createConsumer(Schema<T> schema, List<ReactiveMessageConsumerBuilderCustomizer<T>> customizers) {
        ReactiveMessageConsumerBuilder consumerBuilder = this.reactivePulsarClient.messageConsumer(schema);
        if (!CollectionUtils.isEmpty(this.defaultConfigCustomizers)) {
            this.defaultConfigCustomizers.forEach(customizer -> customizer.customize(consumerBuilder));
        }
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(c -> c.customize(consumerBuilder));
        }
        if (this.topicBuilder != null) {
            this.ensureTopicNamesFullyQualified(consumerBuilder);
        }
        return consumerBuilder.build();
    }

    protected void ensureTopicNamesFullyQualified(ReactiveMessageConsumerBuilder<T> consumerBuilder) {
        MutableReactiveMessageConsumerSpec mutableSpec = consumerBuilder.getMutableSpec();
        List topics = mutableSpec.getTopicNames();
        if (!CollectionUtils.isEmpty((Collection)topics)) {
            List<String> fullyQualifiedTopics = topics.stream().map(arg_0 -> ((PulsarTopicBuilder)this.topicBuilder).getFullyQualifiedNameForTopic(arg_0)).toList();
            mutableSpec.setTopicNames(fullyQualifiedTopics);
        }
    }
}

