/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.springframework.pulsar.autoconfigure.WellKnownAuthParameters;
import org.springframework.util.CollectionUtils;

final class AuthParameterUtils {
    private static final Pattern KEBAB_CASE_PATTERN = Pattern.compile("-(.)");

    private AuthParameterUtils() {
    }

    private static String convertKebabCaseToCamelCase(String kebabString) {
        return KEBAB_CASE_PATTERN.matcher(kebabString).replaceAll(mr -> mr.group(1).toUpperCase());
    }

    private static Map<String, String> convertWellKnownLowerCaseKeysToCamelCase(Map<String, String> params) {
        return params.entrySet().stream().collect(Collectors.toMap(entry -> WellKnownAuthParameters.toCamelCaseKey((String)entry.getKey()), Map.Entry::getValue));
    }

    private static Map<String, String> convertKebabCaseKeysToCamelCase(Map<String, String> params) {
        return params.entrySet().stream().collect(Collectors.toMap(entry -> AuthParameterUtils.convertKebabCaseToCamelCase((String)entry.getKey()), Map.Entry::getValue));
    }

    static String maybeConvertToEncodedParamString(Map<String, String> params) {
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        params = AuthParameterUtils.convertWellKnownLowerCaseKeysToCamelCase(params);
        params = AuthParameterUtils.convertKebabCaseKeysToCamelCase(params);
        params = new TreeMap<String, String>(params);
        try {
            return ObjectMapperFactory.create().writeValueAsString(params);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert parameters to encoded string", e);
        }
    }
}

