/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.autoconfigure.PulsarProperties;

public class ConsumerConfigProperties {
    private Set<String> topics;
    private Pattern topicsPattern;
    private String subscriptionName;
    private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
    private Map<String, String> subscriptionProperties = new HashMap<String, String>();
    private SubscriptionMode subscriptionMode = SubscriptionMode.Durable;
    private Integer receiverQueueSize = 1000;
    private Duration acknowledgementsGroupTime = Duration.ofMillis(100L);
    private Duration negativeAckRedeliveryDelay = Duration.ofMinutes(1L);
    private Integer maxTotalReceiverQueueSizeAcrossPartitions = 50000;
    private String consumerName;
    private Duration ackTimeout = Duration.ZERO;
    private Duration tickDuration = Duration.ofSeconds(1L);
    private Integer priorityLevel = 0;
    private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
    private SortedMap<String, String> properties = new TreeMap<String, String>();
    private Boolean readCompacted = false;
    private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
    private Integer patternAutoDiscoveryPeriod = 1;
    private RegexSubscriptionMode regexSubscriptionMode = RegexSubscriptionMode.PersistentOnly;
    @Nullable
    @NestedConfigurationProperty
    private DeadLetterPolicy deadLetterPolicy;
    private Boolean retryEnable = false;
    private Boolean autoUpdatePartitions = true;
    private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
    private Boolean replicateSubscriptionState = false;
    private Boolean resetIncludeHead = false;
    private Boolean batchIndexAckEnabled = false;
    private Boolean ackReceiptEnabled = false;
    private Boolean poolMessages = false;
    private Boolean startPaused = false;
    private Boolean autoAckOldestChunkedMessageOnQueueFull = true;
    private Integer maxPendingChunkedMessage = 10;
    private Duration expireTimeOfIncompleteChunkedMessage = Duration.ofMinutes(1L);

    public Set<String> getTopics() {
        return this.topics;
    }

    public void setTopics(Set<String> topics) {
        this.topics = topics;
    }

    public Pattern getTopicsPattern() {
        return this.topicsPattern;
    }

    public void setTopicsPattern(Pattern topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public Map<String, String> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    public void setSubscriptionProperties(Map<String, String> subscriptionProperties) {
        this.subscriptionProperties = subscriptionProperties;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public SubscriptionType getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionType subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public Integer getReceiverQueueSize() {
        return this.receiverQueueSize;
    }

    public void setReceiverQueueSize(Integer receiverQueueSize) {
        this.receiverQueueSize = receiverQueueSize;
    }

    public Duration getAcknowledgementsGroupTime() {
        return this.acknowledgementsGroupTime;
    }

    public void setAcknowledgementsGroupTime(Duration acknowledgementsGroupTime) {
        this.acknowledgementsGroupTime = acknowledgementsGroupTime;
    }

    public Duration getNegativeAckRedeliveryDelay() {
        return this.negativeAckRedeliveryDelay;
    }

    public void setNegativeAckRedeliveryDelay(Duration negativeAckRedeliveryDelay) {
        this.negativeAckRedeliveryDelay = negativeAckRedeliveryDelay;
    }

    public Integer getMaxTotalReceiverQueueSizeAcrossPartitions() {
        return this.maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public void setMaxTotalReceiverQueueSizeAcrossPartitions(Integer maxTotalReceiverQueueSizeAcrossPartitions) {
        this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public Duration getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(Duration ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public Duration getTickDuration() {
        return this.tickDuration;
    }

    public void setTickDuration(Duration tickDuration) {
        this.tickDuration = tickDuration;
    }

    public Integer getPriorityLevel() {
        return this.priorityLevel;
    }

    public void setPriorityLevel(Integer priorityLevel) {
        this.priorityLevel = priorityLevel;
    }

    public ConsumerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public SortedMap<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(SortedMap<String, String> properties) {
        this.properties = properties;
    }

    public Boolean getReadCompacted() {
        return this.readCompacted;
    }

    public void setReadCompacted(Boolean readCompacted) {
        this.readCompacted = readCompacted;
    }

    public SubscriptionInitialPosition getSubscriptionInitialPosition() {
        return this.subscriptionInitialPosition;
    }

    public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
        this.subscriptionInitialPosition = subscriptionInitialPosition;
    }

    public Integer getPatternAutoDiscoveryPeriod() {
        return this.patternAutoDiscoveryPeriod;
    }

    public void setPatternAutoDiscoveryPeriod(Integer patternAutoDiscoveryPeriod) {
        this.patternAutoDiscoveryPeriod = patternAutoDiscoveryPeriod;
    }

    public RegexSubscriptionMode getRegexSubscriptionMode() {
        return this.regexSubscriptionMode;
    }

    public void setRegexSubscriptionMode(RegexSubscriptionMode regexSubscriptionMode) {
        this.regexSubscriptionMode = regexSubscriptionMode;
    }

    @Nullable
    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setDeadLetterPolicy(@Nullable DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public Boolean getRetryEnable() {
        return this.retryEnable;
    }

    public void setRetryEnable(Boolean retryEnable) {
        this.retryEnable = retryEnable;
    }

    public Boolean getAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public Duration getAutoUpdatePartitionsInterval() {
        return this.autoUpdatePartitionsInterval;
    }

    public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
    }

    public Boolean getReplicateSubscriptionState() {
        return this.replicateSubscriptionState;
    }

    public void setReplicateSubscriptionState(Boolean replicateSubscriptionState) {
        this.replicateSubscriptionState = replicateSubscriptionState;
    }

    public Boolean getResetIncludeHead() {
        return this.resetIncludeHead;
    }

    public void setResetIncludeHead(Boolean resetIncludeHead) {
        this.resetIncludeHead = resetIncludeHead;
    }

    public Boolean getBatchIndexAckEnabled() {
        return this.batchIndexAckEnabled;
    }

    public void setBatchIndexAckEnabled(Boolean batchIndexAckEnabled) {
        this.batchIndexAckEnabled = batchIndexAckEnabled;
    }

    public Boolean getAckReceiptEnabled() {
        return this.ackReceiptEnabled;
    }

    public void setAckReceiptEnabled(Boolean ackReceiptEnabled) {
        this.ackReceiptEnabled = ackReceiptEnabled;
    }

    public Boolean getPoolMessages() {
        return this.poolMessages;
    }

    public void setPoolMessages(Boolean poolMessages) {
        this.poolMessages = poolMessages;
    }

    public Boolean getStartPaused() {
        return this.startPaused;
    }

    public void setStartPaused(Boolean startPaused) {
        this.startPaused = startPaused;
    }

    public Boolean getAutoAckOldestChunkedMessageOnQueueFull() {
        return this.autoAckOldestChunkedMessageOnQueueFull;
    }

    public void setAutoAckOldestChunkedMessageOnQueueFull(Boolean autoAckOldestChunkedMessageOnQueueFull) {
        this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
    }

    public Integer getMaxPendingChunkedMessage() {
        return this.maxPendingChunkedMessage;
    }

    public void setMaxPendingChunkedMessage(Integer maxPendingChunkedMessage) {
        this.maxPendingChunkedMessage = maxPendingChunkedMessage;
    }

    public Duration getExpireTimeOfIncompleteChunkedMessage() {
        return this.expireTimeOfIncompleteChunkedMessage;
    }

    public void setExpireTimeOfIncompleteChunkedMessage(Duration expireTimeOfIncompleteChunkedMessage) {
        this.expireTimeOfIncompleteChunkedMessage = expireTimeOfIncompleteChunkedMessage;
    }

    public Map<String, Object> buildProperties() {
        PulsarProperties.Properties properties = new PulsarProperties.Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this::getTopics).to(properties.in("topicNames"));
        map.from(this::getTopicsPattern).to(properties.in("topicsPattern"));
        map.from(this::getSubscriptionName).to(properties.in("subscriptionName"));
        map.from(this::getSubscriptionType).to(properties.in("subscriptionType"));
        map.from(this::getSubscriptionProperties).to(properties.in("subscriptionProperties"));
        map.from(this::getSubscriptionMode).to(properties.in("subscriptionMode"));
        map.from(this::getReceiverQueueSize).to(properties.in("receiverQueueSize"));
        map.from(this::getAcknowledgementsGroupTime).as(it -> it.toNanos() / 1000L).to(properties.in("acknowledgementsGroupTimeMicros"));
        map.from(this::getNegativeAckRedeliveryDelay).as(it -> it.toNanos() / 1000L).to(properties.in("negativeAckRedeliveryDelayMicros"));
        map.from(this::getMaxTotalReceiverQueueSizeAcrossPartitions).to(properties.in("maxTotalReceiverQueueSizeAcrossPartitions"));
        map.from(this::getConsumerName).to(properties.in("consumerName"));
        map.from(this::getAckTimeout).as(Duration::toMillis).to(properties.in("ackTimeoutMillis"));
        map.from(this::getTickDuration).as(Duration::toMillis).to(properties.in("tickDurationMillis"));
        map.from(this::getPriorityLevel).to(properties.in("priorityLevel"));
        map.from(this::getCryptoFailureAction).to(properties.in("cryptoFailureAction"));
        map.from(this::getProperties).to(properties.in("properties"));
        map.from(this::getReadCompacted).to(properties.in("readCompacted"));
        map.from(this::getSubscriptionInitialPosition).to(properties.in("subscriptionInitialPosition"));
        map.from(this::getPatternAutoDiscoveryPeriod).to(properties.in("patternAutoDiscoveryPeriod"));
        map.from(this::getRegexSubscriptionMode).to(properties.in("regexSubscriptionMode"));
        map.from(this::getDeadLetterPolicy).to(properties.in("deadLetterPolicy"));
        map.from(this::getRetryEnable).to(properties.in("retryEnable"));
        map.from(this::getAutoUpdatePartitions).to(properties.in("autoUpdatePartitions"));
        map.from(this::getAutoUpdatePartitionsInterval).as(Duration::toSeconds).to(properties.in("autoUpdatePartitionsIntervalSeconds"));
        map.from(this::getReplicateSubscriptionState).to(properties.in("replicateSubscriptionState"));
        map.from(this::getResetIncludeHead).to(properties.in("resetIncludeHead"));
        map.from(this::getBatchIndexAckEnabled).to(properties.in("batchIndexAckEnabled"));
        map.from(this::getAckReceiptEnabled).to(properties.in("ackReceiptEnabled"));
        map.from(this::getPoolMessages).to(properties.in("poolMessages"));
        map.from(this::getStartPaused).to(properties.in("startPaused"));
        map.from(this::getAutoAckOldestChunkedMessageOnQueueFull).to(properties.in("autoAckOldestChunkedMessageOnQueueFull"));
        map.from(this::getMaxPendingChunkedMessage).to(properties.in("maxPendingChunkedMessage"));
        map.from(this::getExpireTimeOfIncompleteChunkedMessage).as(Duration::toMillis).to(properties.in("expireTimeOfIncompleteChunkedMessageMillis"));
        return properties;
    }
}

