/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.autoconfigure.PulsarProperties;
import org.springframework.util.unit.DataSize;

public class ProducerConfigProperties {
    private String topicName;
    private String producerName;
    private Duration sendTimeout = Duration.ofSeconds(30L);
    private Boolean blockIfQueueFull = false;
    private Integer maxPendingMessages = 1000;
    private Integer maxPendingMessagesAcrossPartitions = 50000;
    private MessageRoutingMode messageRoutingMode = MessageRoutingMode.RoundRobinPartition;
    private HashingScheme hashingScheme = HashingScheme.JavaStringHash;
    private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;
    private Duration batchingMaxPublishDelay = Duration.ofMillis(1L);
    private Integer batchingPartitionSwitchFrequencyByPublishDelay = 10;
    private Integer batchingMaxMessages = 1000;
    private DataSize batchingMaxBytes = DataSize.ofKilobytes((long)128L);
    private Boolean batchingEnabled = true;
    private Boolean chunkingEnabled = false;
    private Set<String> encryptionKeys = new HashSet<String>();
    private CompressionType compressionType;
    @Nullable
    private Long initialSequenceId;
    private Boolean autoUpdatePartitions = true;
    private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
    private Boolean multiSchema = true;
    private ProducerAccessMode producerAccessMode = ProducerAccessMode.Shared;
    private Boolean lazyStartPartitionedProducers = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private final PulsarProperties.Cache cache = new PulsarProperties.Cache();

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public void setProducerName(String producerName) {
        this.producerName = producerName;
    }

    public Duration getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(Duration sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public Boolean getBlockIfQueueFull() {
        return this.blockIfQueueFull;
    }

    public void setBlockIfQueueFull(Boolean blockIfQueueFull) {
        this.blockIfQueueFull = blockIfQueueFull;
    }

    public Integer getMaxPendingMessages() {
        return this.maxPendingMessages;
    }

    public void setMaxPendingMessages(Integer maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
    }

    public Integer getMaxPendingMessagesAcrossPartitions() {
        return this.maxPendingMessagesAcrossPartitions;
    }

    public void setMaxPendingMessagesAcrossPartitions(Integer maxPendingMessagesAcrossPartitions) {
        this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
    }

    public MessageRoutingMode getMessageRoutingMode() {
        return this.messageRoutingMode;
    }

    public void setMessageRoutingMode(MessageRoutingMode messageRoutingMode) {
        this.messageRoutingMode = messageRoutingMode;
    }

    public HashingScheme getHashingScheme() {
        return this.hashingScheme;
    }

    public void setHashingScheme(HashingScheme hashingScheme) {
        this.hashingScheme = hashingScheme;
    }

    public ProducerCryptoFailureAction getCryptoFailureAction() {
        return this.cryptoFailureAction;
    }

    public void setCryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
        this.cryptoFailureAction = cryptoFailureAction;
    }

    public Duration getBatchingMaxPublishDelay() {
        return this.batchingMaxPublishDelay;
    }

    public void setBatchingMaxPublishDelay(Duration batchingMaxPublishDelay) {
        this.batchingMaxPublishDelay = batchingMaxPublishDelay;
    }

    public Integer getBatchingPartitionSwitchFrequencyByPublishDelay() {
        return this.batchingPartitionSwitchFrequencyByPublishDelay;
    }

    public void setBatchingPartitionSwitchFrequencyByPublishDelay(Integer batchingPartitionSwitchFrequencyByPublishDelay) {
        this.batchingPartitionSwitchFrequencyByPublishDelay = batchingPartitionSwitchFrequencyByPublishDelay;
    }

    public Integer getBatchingMaxMessages() {
        return this.batchingMaxMessages;
    }

    public void setBatchingMaxMessages(Integer batchingMaxMessages) {
        this.batchingMaxMessages = batchingMaxMessages;
    }

    public DataSize getBatchingMaxBytes() {
        return this.batchingMaxBytes;
    }

    public void setBatchingMaxBytes(DataSize batchingMaxBytes) {
        this.batchingMaxBytes = batchingMaxBytes;
    }

    public Boolean getBatchingEnabled() {
        return this.batchingEnabled;
    }

    public void setBatchingEnabled(Boolean batchingEnabled) {
        this.batchingEnabled = batchingEnabled;
    }

    public Boolean getChunkingEnabled() {
        return this.chunkingEnabled;
    }

    public void setChunkingEnabled(Boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
    }

    public Set<String> getEncryptionKeys() {
        return this.encryptionKeys;
    }

    public void setEncryptionKeys(Set<String> encryptionKeys) {
        this.encryptionKeys = encryptionKeys;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    @Nullable
    public Long getInitialSequenceId() {
        return this.initialSequenceId;
    }

    public void setInitialSequenceId(@Nullable Long initialSequenceId) {
        this.initialSequenceId = initialSequenceId;
    }

    public Boolean getAutoUpdatePartitions() {
        return this.autoUpdatePartitions;
    }

    public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
        this.autoUpdatePartitions = autoUpdatePartitions;
    }

    public Duration getAutoUpdatePartitionsInterval() {
        return this.autoUpdatePartitionsInterval;
    }

    public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
        this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
    }

    public Boolean getMultiSchema() {
        return this.multiSchema;
    }

    public void setMultiSchema(Boolean multiSchema) {
        this.multiSchema = multiSchema;
    }

    public ProducerAccessMode getProducerAccessMode() {
        return this.producerAccessMode;
    }

    public void setProducerAccessMode(ProducerAccessMode producerAccessMode) {
        this.producerAccessMode = producerAccessMode;
    }

    public Boolean getLazyStartPartitionedProducers() {
        return this.lazyStartPartitionedProducers;
    }

    public void setLazyStartPartitionedProducers(Boolean lazyStartPartitionedProducers) {
        this.lazyStartPartitionedProducers = lazyStartPartitionedProducers;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public PulsarProperties.Cache getCache() {
        return this.cache;
    }

    public Map<String, Object> buildProperties() {
        PulsarProperties.Properties properties = new PulsarProperties.Properties();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this::getTopicName).to(properties.in("topicName"));
        map.from(this::getProducerName).to(properties.in("producerName"));
        map.from(this::getSendTimeout).asInt(Duration::toMillis).to(properties.in("sendTimeoutMs"));
        map.from(this::getBlockIfQueueFull).to(properties.in("blockIfQueueFull"));
        map.from(this::getMaxPendingMessages).to(properties.in("maxPendingMessages"));
        map.from(this::getMaxPendingMessagesAcrossPartitions).to(properties.in("maxPendingMessagesAcrossPartitions"));
        map.from(this::getMessageRoutingMode).to(properties.in("messageRoutingMode"));
        map.from(this::getHashingScheme).to(properties.in("hashingScheme"));
        map.from(this::getCryptoFailureAction).to(properties.in("cryptoFailureAction"));
        map.from(this::getBatchingMaxPublishDelay).as(it -> it.toNanos() / 1000L).to(properties.in("batchingMaxPublishDelayMicros"));
        map.from(this::getBatchingPartitionSwitchFrequencyByPublishDelay).to(properties.in("batchingPartitionSwitchFrequencyByPublishDelay"));
        map.from(this::getBatchingMaxMessages).to(properties.in("batchingMaxMessages"));
        map.from(this::getBatchingMaxBytes).asInt(DataSize::toBytes).to(properties.in("batchingMaxBytes"));
        map.from(this::getBatchingEnabled).to(properties.in("batchingEnabled"));
        map.from(this::getChunkingEnabled).to(properties.in("chunkingEnabled"));
        map.from(this::getEncryptionKeys).to(properties.in("encryptionKeys"));
        map.from(this::getCompressionType).to(properties.in("compressionType"));
        map.from(this::getInitialSequenceId).to(properties.in("initialSequenceId"));
        map.from(this::getAutoUpdatePartitions).to(properties.in("autoUpdatePartitions"));
        map.from(this::getAutoUpdatePartitionsInterval).as(Duration::toSeconds).to(properties.in("autoUpdatePartitionsIntervalSeconds"));
        map.from(this::getMultiSchema).to(properties.in("multiSchema"));
        map.from(this::getProducerAccessMode).to(properties.in("accessMode"));
        map.from(this::getLazyStartPartitionedProducers).to(properties.in("lazyStartPartitionedProducers"));
        map.from(this::getProperties).to(properties.in("properties"));
        return properties;
    }
}

