/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.micrometer.observation.ObservationRegistry;
import java.util.Optional;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.interceptor.ProducerInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.pulsar.autoconfigure.PulsarAnnotationDrivenConfiguration;
import org.springframework.pulsar.autoconfigure.PulsarProperties;
import org.springframework.pulsar.config.PulsarClientFactoryBean;
import org.springframework.pulsar.core.CachingPulsarProducerFactory;
import org.springframework.pulsar.core.DefaultPulsarConsumerFactory;
import org.springframework.pulsar.core.DefaultPulsarProducerFactory;
import org.springframework.pulsar.core.DefaultPulsarReaderFactory;
import org.springframework.pulsar.core.DefaultSchemaResolver;
import org.springframework.pulsar.core.DefaultTopicResolver;
import org.springframework.pulsar.core.PulsarAdministration;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.core.PulsarProducerFactory;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.PulsarTemplate;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.function.PulsarFunction;
import org.springframework.pulsar.function.PulsarFunctionAdministration;
import org.springframework.pulsar.function.PulsarSink;
import org.springframework.pulsar.function.PulsarSource;
import org.springframework.pulsar.observation.PulsarTemplateObservationConvention;

@AutoConfiguration
@ConditionalOnClass(value={PulsarTemplate.class})
@EnableConfigurationProperties(value={PulsarProperties.class})
@Import(value={PulsarAnnotationDrivenConfiguration.class})
public class PulsarAutoConfiguration {
    private final PulsarProperties properties;

    public PulsarAutoConfiguration(PulsarProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarClientFactoryBean pulsarClientFactoryBean() {
        return new PulsarClientFactoryBean(this.properties.buildClientProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="false")
    public PulsarProducerFactory<?> pulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver) {
        return new DefaultPulsarProducerFactory(pulsarClient, this.properties.buildProducerProperties(), topicResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Caffeine.class})
    @ConditionalOnProperty(name={"spring.pulsar.producer.cache.enabled"}, havingValue="true", matchIfMissing=true)
    public PulsarProducerFactory<?> cachingPulsarProducerFactory(PulsarClient pulsarClient, TopicResolver topicResolver) {
        return new CachingPulsarProducerFactory(pulsarClient, this.properties.buildProducerProperties(), topicResolver, this.properties.getProducer().getCache().getExpireAfterAccess(), this.properties.getProducer().getCache().getMaximumSize(), this.properties.getProducer().getCache().getInitialCapacity());
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarTemplate<?> pulsarTemplate(PulsarProducerFactory<?> pulsarProducerFactory, ObjectProvider<ProducerInterceptor> interceptorsProvider, SchemaResolver schemaResolver, TopicResolver topicResolver, ObjectProvider<ObservationRegistry> observationRegistryProvider, ObjectProvider<PulsarTemplateObservationConvention> observationConventionProvider) {
        return new PulsarTemplate(pulsarProducerFactory, interceptorsProvider.orderedStream().toList(), schemaResolver, topicResolver, this.properties.getTemplate().isObservationsEnabled() != false ? (ObservationRegistry)observationRegistryProvider.getIfUnique() : null, (PulsarTemplateObservationConvention)observationConventionProvider.getIfUnique());
    }

    @Bean
    @ConditionalOnMissingBean(value={SchemaResolver.class})
    public DefaultSchemaResolver schemaResolver(PulsarProperties pulsarProperties, Optional<SchemaResolver.SchemaResolverCustomizer<DefaultSchemaResolver>> schemaResolverCustomizer) {
        DefaultSchemaResolver schemaResolver = new DefaultSchemaResolver();
        if (pulsarProperties.getDefaults().getTypeMappings() != null) {
            pulsarProperties.getDefaults().getTypeMappings().stream().filter(tm -> tm.schemaInfo() != null).forEach(tm -> {
                Schema schema = (Schema)schemaResolver.resolveSchema(tm.schemaInfo().schemaType(), tm.messageType(), tm.schemaInfo().messageKeyType()).orElseThrow();
                schemaResolver.addCustomSchemaMapping(tm.messageType(), schema);
            });
        }
        schemaResolverCustomizer.ifPresent(customizer -> customizer.customize((SchemaResolver)schemaResolver));
        return schemaResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={TopicResolver.class})
    public DefaultTopicResolver topicResolver(PulsarProperties pulsarProperties) {
        DefaultTopicResolver topicResolver = new DefaultTopicResolver();
        if (pulsarProperties.getDefaults().getTypeMappings() != null) {
            pulsarProperties.getDefaults().getTypeMappings().stream().filter(tm -> tm.topicName() != null).forEach(tm -> topicResolver.addCustomTopicMapping(tm.messageType(), tm.topicName()));
        }
        return topicResolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarConsumerFactory<?> pulsarConsumerFactory(PulsarClient pulsarClient) {
        return new DefaultPulsarConsumerFactory(pulsarClient, this.properties.buildConsumerProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarAdministration pulsarAdministration() {
        return new PulsarAdministration(this.properties.buildAdminProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.pulsar.function.enabled"}, havingValue="true", matchIfMissing=true)
    public PulsarFunctionAdministration pulsarFunctionAdministration(PulsarAdministration pulsarAdministration, ObjectProvider<PulsarFunction> pulsarFunctions, ObjectProvider<PulsarSink> pulsarSinks, ObjectProvider<PulsarSource> pulsarSources) {
        return new PulsarFunctionAdministration(pulsarAdministration, pulsarFunctions, pulsarSinks, pulsarSources, this.properties.getFunction().getFailFast().booleanValue(), this.properties.getFunction().getPropagateFailures().booleanValue(), this.properties.getFunction().getPropagateStopFailures().booleanValue());
    }

    @Bean
    @ConditionalOnMissingBean
    public PulsarReaderFactory<?> pulsarReaderFactory(PulsarClient pulsarClient) {
        return new DefaultPulsarReaderFactory(pulsarClient, this.properties.buildReaderProperties());
    }
}

