/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.pulsar.autoconfigure.PulsarReactiveProperties;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.reactive.config.DefaultReactivePulsarListenerContainerFactory;
import org.springframework.pulsar.reactive.config.annotation.EnableReactivePulsar;
import org.springframework.pulsar.reactive.core.ReactivePulsarConsumerFactory;
import org.springframework.pulsar.reactive.listener.ReactivePulsarContainerProperties;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EnableReactivePulsar.class})
public class PulsarReactiveAnnotationDrivenConfiguration {
    private final PulsarReactiveProperties properties;

    public PulsarReactiveAnnotationDrivenConfiguration(PulsarReactiveProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"reactivePulsarListenerContainerFactory"})
    DefaultReactivePulsarListenerContainerFactory<?> reactivePulsarListenerContainerFactory(ObjectProvider<ReactivePulsarConsumerFactory<Object>> consumerFactoryProvider, SchemaResolver schemaResolver, TopicResolver topicResolver) {
        ReactivePulsarContainerProperties containerProperties = new ReactivePulsarContainerProperties();
        containerProperties.setSchemaResolver(schemaResolver);
        containerProperties.setTopicResolver(topicResolver);
        containerProperties.setSubscriptionType(this.properties.getConsumer().getSubscriptionType());
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        PulsarReactiveProperties.Listener listenerProperties = this.properties.getListener();
        map.from(listenerProperties::getSchemaType).to(arg_0 -> ((ReactivePulsarContainerProperties)containerProperties).setSchemaType(arg_0));
        map.from(listenerProperties::getHandlingTimeout).to(arg_0 -> ((ReactivePulsarContainerProperties)containerProperties).setHandlingTimeout(arg_0));
        map.from(listenerProperties::getUseKeyOrderedProcessing).to(arg_0 -> ((ReactivePulsarContainerProperties)containerProperties).setUseKeyOrderedProcessing(arg_0));
        return new DefaultReactivePulsarListenerContainerFactory((ReactivePulsarConsumerFactory)consumerFactoryProvider.getIfAvailable(), containerProperties);
    }

    @Configuration(proxyBeanMethods=false)
    @EnableReactivePulsar
    @ConditionalOnMissingBean(name={"org.springframework.pulsar.config.internalReactivePulsarListenerAnnotationProcessor"})
    static class EnableReactivePulsarConfiguration {
        EnableReactivePulsarConfiguration() {
        }
    }
}

