/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionMode;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ImmutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.MutableReactiveMessageSenderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageConsumerSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageReaderSpec;
import org.apache.pulsar.reactive.client.api.ReactiveMessageSenderSpec;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.unit.DataSize;
import reactor.core.scheduler.Schedulers;

@ConfigurationProperties(prefix="spring.pulsar.reactive")
public class PulsarReactiveProperties {
    private final Sender sender = new Sender();
    private final Consumer consumer = new Consumer();
    private final Reader reader = new Reader();
    private final Listener listener = new Listener();

    public Sender getSender() {
        return this.sender;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Reader getReader() {
        return this.reader;
    }

    public Listener getListener() {
        return this.listener;
    }

    public ReactiveMessageSenderSpec buildReactiveMessageSenderSpec() {
        return this.sender.buildReactiveMessageSenderSpec();
    }

    public ReactiveMessageReaderSpec buildReactiveMessageReaderSpec() {
        return this.reader.buildReactiveMessageReaderSpec();
    }

    public ReactiveMessageConsumerSpec buildReactiveMessageConsumerSpec() {
        return this.consumer.buildReactiveMessageConsumerSpec();
    }

    public static class Sender {
        private String topicName;
        private String producerName;
        private Duration sendTimeout = Duration.ofSeconds(30L);
        private Integer maxPendingMessages = 1000;
        private Integer maxPendingMessagesAcrossPartitions = 50000;
        private MessageRoutingMode messageRoutingMode = MessageRoutingMode.RoundRobinPartition;
        private HashingScheme hashingScheme = HashingScheme.JavaStringHash;
        private ProducerCryptoFailureAction cryptoFailureAction = ProducerCryptoFailureAction.FAIL;
        private Duration batchingMaxPublishDelay = Duration.ofMillis(1L);
        private Integer roundRobinRouterBatchingPartitionSwitchFrequency;
        private Integer batchingMaxMessages = 1000;
        private DataSize batchingMaxBytes = DataSize.ofKilobytes((long)128L);
        private Boolean batchingEnabled = true;
        private Boolean chunkingEnabled = false;
        private Set<String> encryptionKeys = new HashSet<String>();
        private CompressionType compressionType;
        @Nullable
        private Long initialSequenceId;
        private Boolean autoUpdatePartitions = true;
        private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
        private Boolean multiSchema = true;
        private ProducerAccessMode producerAccessMode = ProducerAccessMode.Shared;
        private Boolean lazyStartPartitionedProducers = false;
        private Map<String, String> properties = new HashMap<String, String>();
        private final Cache cache = new Cache();

        public String getTopicName() {
            return this.topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public String getProducerName() {
            return this.producerName;
        }

        public void setProducerName(String producerName) {
            this.producerName = producerName;
        }

        public Duration getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(Duration sendTimeout) {
            this.sendTimeout = sendTimeout;
        }

        public Integer getMaxPendingMessages() {
            return this.maxPendingMessages;
        }

        public void setMaxPendingMessages(Integer maxPendingMessages) {
            this.maxPendingMessages = maxPendingMessages;
        }

        public Integer getMaxPendingMessagesAcrossPartitions() {
            return this.maxPendingMessagesAcrossPartitions;
        }

        public void setMaxPendingMessagesAcrossPartitions(Integer maxPendingMessagesAcrossPartitions) {
            this.maxPendingMessagesAcrossPartitions = maxPendingMessagesAcrossPartitions;
        }

        public MessageRoutingMode getMessageRoutingMode() {
            return this.messageRoutingMode;
        }

        public void setMessageRoutingMode(MessageRoutingMode messageRoutingMode) {
            this.messageRoutingMode = messageRoutingMode;
        }

        public HashingScheme getHashingScheme() {
            return this.hashingScheme;
        }

        public void setHashingScheme(HashingScheme hashingScheme) {
            this.hashingScheme = hashingScheme;
        }

        public ProducerCryptoFailureAction getCryptoFailureAction() {
            return this.cryptoFailureAction;
        }

        public void setCryptoFailureAction(ProducerCryptoFailureAction cryptoFailureAction) {
            this.cryptoFailureAction = cryptoFailureAction;
        }

        public Duration getBatchingMaxPublishDelay() {
            return this.batchingMaxPublishDelay;
        }

        public void setBatchingMaxPublishDelay(Duration batchingMaxPublishDelay) {
            this.batchingMaxPublishDelay = batchingMaxPublishDelay;
        }

        public Integer getRoundRobinRouterBatchingPartitionSwitchFrequency() {
            return this.roundRobinRouterBatchingPartitionSwitchFrequency;
        }

        public void setRoundRobinRouterBatchingPartitionSwitchFrequency(Integer roundRobinRouterBatchingPartitionSwitchFrequency) {
            this.roundRobinRouterBatchingPartitionSwitchFrequency = roundRobinRouterBatchingPartitionSwitchFrequency;
        }

        public Integer getBatchingMaxMessages() {
            return this.batchingMaxMessages;
        }

        public void setBatchingMaxMessages(Integer batchingMaxMessages) {
            this.batchingMaxMessages = batchingMaxMessages;
        }

        public DataSize getBatchingMaxBytes() {
            return this.batchingMaxBytes;
        }

        public void setBatchingMaxBytes(DataSize batchingMaxBytes) {
            this.batchingMaxBytes = batchingMaxBytes;
        }

        public Boolean getBatchingEnabled() {
            return this.batchingEnabled;
        }

        public void setBatchingEnabled(Boolean batchingEnabled) {
            this.batchingEnabled = batchingEnabled;
        }

        public Boolean getChunkingEnabled() {
            return this.chunkingEnabled;
        }

        public void setChunkingEnabled(Boolean chunkingEnabled) {
            this.chunkingEnabled = chunkingEnabled;
        }

        public Set<String> getEncryptionKeys() {
            return this.encryptionKeys;
        }

        public void setEncryptionKeys(Set<String> encryptionKeys) {
            this.encryptionKeys = encryptionKeys;
        }

        public CompressionType getCompressionType() {
            return this.compressionType;
        }

        public void setCompressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
        }

        @Nullable
        public Long getInitialSequenceId() {
            return this.initialSequenceId;
        }

        public void setInitialSequenceId(@Nullable Long initialSequenceId) {
            this.initialSequenceId = initialSequenceId;
        }

        public Boolean getAutoUpdatePartitions() {
            return this.autoUpdatePartitions;
        }

        public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
            this.autoUpdatePartitions = autoUpdatePartitions;
        }

        public Duration getAutoUpdatePartitionsInterval() {
            return this.autoUpdatePartitionsInterval;
        }

        public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
            this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
        }

        public Boolean getMultiSchema() {
            return this.multiSchema;
        }

        public void setMultiSchema(Boolean multiSchema) {
            this.multiSchema = multiSchema;
        }

        public ProducerAccessMode getProducerAccessMode() {
            return this.producerAccessMode;
        }

        public void setProducerAccessMode(ProducerAccessMode producerAccessMode) {
            this.producerAccessMode = producerAccessMode;
        }

        public Boolean getLazyStartPartitionedProducers() {
            return this.lazyStartPartitionedProducers;
        }

        public void setLazyStartPartitionedProducers(Boolean lazyStartPartitionedProducers) {
            this.lazyStartPartitionedProducers = lazyStartPartitionedProducers;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Cache getCache() {
            return this.cache;
        }

        public ReactiveMessageSenderSpec buildReactiveMessageSenderSpec() {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            MutableReactiveMessageSenderSpec spec = new MutableReactiveMessageSenderSpec();
            map.from(this::getTopicName).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setTopicName(arg_0));
            map.from(this::getProducerName).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setProducerName(arg_0));
            map.from(this::getSendTimeout).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setSendTimeout(arg_0));
            map.from(this::getMaxPendingMessages).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setMaxPendingMessages(arg_0));
            map.from(this::getMaxPendingMessagesAcrossPartitions).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setMaxPendingMessagesAcrossPartitions(arg_0));
            map.from(this::getMessageRoutingMode).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setMessageRoutingMode(arg_0));
            map.from(this::getHashingScheme).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setHashingScheme(arg_0));
            map.from(this::getCryptoFailureAction).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setCryptoFailureAction(arg_0));
            map.from(this::getBatchingMaxPublishDelay).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setBatchingMaxPublishDelay(arg_0));
            map.from(this::getRoundRobinRouterBatchingPartitionSwitchFrequency).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setRoundRobinRouterBatchingPartitionSwitchFrequency(arg_0));
            map.from(this::getBatchingMaxMessages).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setBatchingMaxMessages(arg_0));
            map.from(this::getBatchingMaxBytes).asInt(DataSize::toBytes).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setBatchingMaxBytes(arg_0));
            map.from(this::getBatchingEnabled).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setBatchingEnabled(arg_0));
            map.from(this::getChunkingEnabled).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setChunkingEnabled(arg_0));
            map.from(this::getEncryptionKeys).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setEncryptionKeys(arg_0));
            map.from(this::getCompressionType).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setCompressionType(arg_0));
            map.from(this::getInitialSequenceId).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setInitialSequenceId(arg_0));
            map.from(this::getAutoUpdatePartitions).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setAutoUpdatePartitions(arg_0));
            map.from(this::getAutoUpdatePartitionsInterval).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setAutoUpdatePartitionsInterval(arg_0));
            map.from(this::getMultiSchema).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setMultiSchema(arg_0));
            map.from(this::getProducerAccessMode).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setAccessMode(arg_0));
            map.from(this::getLazyStartPartitionedProducers).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setLazyStartPartitionedProducers(arg_0));
            map.from(this::getProperties).to(arg_0 -> ((MutableReactiveMessageSenderSpec)spec).setProperties(arg_0));
            return new ImmutableReactiveMessageSenderSpec((ReactiveMessageSenderSpec)spec);
        }
    }

    public static class Consumer {
        private String[] topics;
        private Pattern topicsPattern;
        private String subscriptionName;
        private SubscriptionType subscriptionType = SubscriptionType.Exclusive;
        private SortedMap<String, String> subscriptionProperties = new TreeMap<String, String>();
        private SubscriptionMode subscriptionMode = SubscriptionMode.Durable;
        private Integer receiverQueueSize = 1000;
        private Duration acknowledgementsGroupTime = Duration.ofMillis(100L);
        private Boolean acknowledgeAsynchronously = true;
        private SchedulerType acknowledgeSchedulerType;
        private Duration negativeAckRedeliveryDelay = Duration.ofMinutes(1L);
        @NestedConfigurationProperty
        private DeadLetterPolicy deadLetterPolicy;
        private Boolean retryLetterTopicEnable = false;
        private Integer maxTotalReceiverQueueSizeAcrossPartitions = 50000;
        private String consumerName;
        private Duration ackTimeout = Duration.ZERO;
        private Duration ackTimeoutTickTime = Duration.ofSeconds(1L);
        private Integer priorityLevel = 0;
        private ConsumerCryptoFailureAction cryptoFailureAction = ConsumerCryptoFailureAction.FAIL;
        private SortedMap<String, String> properties = new TreeMap<String, String>();
        private Boolean readCompacted = false;
        private Boolean batchIndexAckEnabled = false;
        private SubscriptionInitialPosition subscriptionInitialPosition = SubscriptionInitialPosition.Latest;
        private Duration topicsPatternAutoDiscoveryPeriod = Duration.ofMinutes(1L);
        private RegexSubscriptionMode topicsPatternSubscriptionMode = RegexSubscriptionMode.PersistentOnly;
        private Boolean autoUpdatePartitions = true;
        private Duration autoUpdatePartitionsInterval = Duration.ofMinutes(1L);
        private Boolean replicateSubscriptionState = false;
        private Boolean autoAckOldestChunkedMessageOnQueueFull = true;
        private Integer maxPendingChunkedMessage = 10;
        private Duration expireTimeOfIncompleteChunkedMessage = Duration.ofMinutes(1L);

        public String[] getTopics() {
            return this.topics;
        }

        public void setTopics(String[] topics) {
            this.topics = topics;
        }

        public Pattern getTopicsPattern() {
            return this.topicsPattern;
        }

        public void setTopicsPattern(Pattern topicsPattern) {
            this.topicsPattern = topicsPattern;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public SubscriptionType getSubscriptionType() {
            return this.subscriptionType;
        }

        public void setSubscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public SortedMap<String, String> getSubscriptionProperties() {
            return this.subscriptionProperties;
        }

        public void setSubscriptionProperties(SortedMap<String, String> subscriptionProperties) {
            this.subscriptionProperties = subscriptionProperties;
        }

        public SubscriptionMode getSubscriptionMode() {
            return this.subscriptionMode;
        }

        public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
            this.subscriptionMode = subscriptionMode;
        }

        public Integer getReceiverQueueSize() {
            return this.receiverQueueSize;
        }

        public void setReceiverQueueSize(Integer receiverQueueSize) {
            this.receiverQueueSize = receiverQueueSize;
        }

        public Duration getAcknowledgementsGroupTime() {
            return this.acknowledgementsGroupTime;
        }

        public void setAcknowledgementsGroupTime(Duration acknowledgementsGroupTime) {
            this.acknowledgementsGroupTime = acknowledgementsGroupTime;
        }

        public Boolean getAcknowledgeAsynchronously() {
            return this.acknowledgeAsynchronously;
        }

        public void setAcknowledgeAsynchronously(Boolean acknowledgeAsynchronously) {
            this.acknowledgeAsynchronously = acknowledgeAsynchronously;
        }

        public SchedulerType getAcknowledgeSchedulerType() {
            return this.acknowledgeSchedulerType;
        }

        public void setAcknowledgeSchedulerType(SchedulerType acknowledgeSchedulerType) {
            this.acknowledgeSchedulerType = acknowledgeSchedulerType;
        }

        public Duration getNegativeAckRedeliveryDelay() {
            return this.negativeAckRedeliveryDelay;
        }

        public void setNegativeAckRedeliveryDelay(Duration negativeAckRedeliveryDelay) {
            this.negativeAckRedeliveryDelay = negativeAckRedeliveryDelay;
        }

        public DeadLetterPolicy getDeadLetterPolicy() {
            return this.deadLetterPolicy;
        }

        public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
            this.deadLetterPolicy = deadLetterPolicy;
        }

        public Boolean getRetryLetterTopicEnable() {
            return this.retryLetterTopicEnable;
        }

        public void setRetryLetterTopicEnable(Boolean retryLetterTopicEnable) {
            this.retryLetterTopicEnable = retryLetterTopicEnable;
        }

        public Integer getMaxTotalReceiverQueueSizeAcrossPartitions() {
            return this.maxTotalReceiverQueueSizeAcrossPartitions;
        }

        public void setMaxTotalReceiverQueueSizeAcrossPartitions(Integer maxTotalReceiverQueueSizeAcrossPartitions) {
            this.maxTotalReceiverQueueSizeAcrossPartitions = maxTotalReceiverQueueSizeAcrossPartitions;
        }

        public String getConsumerName() {
            return this.consumerName;
        }

        public void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        public Duration getAckTimeout() {
            return this.ackTimeout;
        }

        public void setAckTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
        }

        public Duration getAckTimeoutTickTime() {
            return this.ackTimeoutTickTime;
        }

        public void setAckTimeoutTickTime(Duration ackTimeoutTickTime) {
            this.ackTimeoutTickTime = ackTimeoutTickTime;
        }

        public Integer getPriorityLevel() {
            return this.priorityLevel;
        }

        public void setPriorityLevel(Integer priorityLevel) {
            this.priorityLevel = priorityLevel;
        }

        public ConsumerCryptoFailureAction getCryptoFailureAction() {
            return this.cryptoFailureAction;
        }

        public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
            this.cryptoFailureAction = cryptoFailureAction;
        }

        public SortedMap<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(SortedMap<String, String> properties) {
            this.properties = properties;
        }

        public Boolean getReadCompacted() {
            return this.readCompacted;
        }

        public void setReadCompacted(Boolean readCompacted) {
            this.readCompacted = readCompacted;
        }

        public Boolean getBatchIndexAckEnabled() {
            return this.batchIndexAckEnabled;
        }

        public void setBatchIndexAckEnabled(Boolean batchIndexAckEnabled) {
            this.batchIndexAckEnabled = batchIndexAckEnabled;
        }

        public SubscriptionInitialPosition getSubscriptionInitialPosition() {
            return this.subscriptionInitialPosition;
        }

        public void setSubscriptionInitialPosition(SubscriptionInitialPosition subscriptionInitialPosition) {
            this.subscriptionInitialPosition = subscriptionInitialPosition;
        }

        public Duration getTopicsPatternAutoDiscoveryPeriod() {
            return this.topicsPatternAutoDiscoveryPeriod;
        }

        public void setTopicsPatternAutoDiscoveryPeriod(Duration topicsPatternAutoDiscoveryPeriod) {
            this.topicsPatternAutoDiscoveryPeriod = topicsPatternAutoDiscoveryPeriod;
        }

        public RegexSubscriptionMode getTopicsPatternSubscriptionMode() {
            return this.topicsPatternSubscriptionMode;
        }

        public void setTopicsPatternSubscriptionMode(RegexSubscriptionMode topicsPatternSubscriptionMode) {
            this.topicsPatternSubscriptionMode = topicsPatternSubscriptionMode;
        }

        public Boolean getAutoUpdatePartitions() {
            return this.autoUpdatePartitions;
        }

        public void setAutoUpdatePartitions(Boolean autoUpdatePartitions) {
            this.autoUpdatePartitions = autoUpdatePartitions;
        }

        public Duration getAutoUpdatePartitionsInterval() {
            return this.autoUpdatePartitionsInterval;
        }

        public void setAutoUpdatePartitionsInterval(Duration autoUpdatePartitionsInterval) {
            this.autoUpdatePartitionsInterval = autoUpdatePartitionsInterval;
        }

        public Boolean getReplicateSubscriptionState() {
            return this.replicateSubscriptionState;
        }

        public void setReplicateSubscriptionState(Boolean replicateSubscriptionState) {
            this.replicateSubscriptionState = replicateSubscriptionState;
        }

        public Boolean getAutoAckOldestChunkedMessageOnQueueFull() {
            return this.autoAckOldestChunkedMessageOnQueueFull;
        }

        public void setAutoAckOldestChunkedMessageOnQueueFull(Boolean autoAckOldestChunkedMessageOnQueueFull) {
            this.autoAckOldestChunkedMessageOnQueueFull = autoAckOldestChunkedMessageOnQueueFull;
        }

        public Integer getMaxPendingChunkedMessage() {
            return this.maxPendingChunkedMessage;
        }

        public void setMaxPendingChunkedMessage(Integer maxPendingChunkedMessage) {
            this.maxPendingChunkedMessage = maxPendingChunkedMessage;
        }

        public Duration getExpireTimeOfIncompleteChunkedMessage() {
            return this.expireTimeOfIncompleteChunkedMessage;
        }

        public void setExpireTimeOfIncompleteChunkedMessage(Duration expireTimeOfIncompleteChunkedMessage) {
            this.expireTimeOfIncompleteChunkedMessage = expireTimeOfIncompleteChunkedMessage;
        }

        public ReactiveMessageConsumerSpec buildReactiveMessageConsumerSpec() {
            MutableReactiveMessageConsumerSpec spec = new MutableReactiveMessageConsumerSpec();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from(this::getTopics).as(List::of).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setTopicNames(arg_0));
            map.from(this::getTopicsPattern).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setTopicsPattern(arg_0));
            map.from(this::getSubscriptionName).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setSubscriptionName(arg_0));
            map.from(this::getSubscriptionType).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setSubscriptionType(arg_0));
            map.from(this::getSubscriptionProperties).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setSubscriptionProperties(arg_0));
            map.from(this::getSubscriptionMode).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setSubscriptionMode(arg_0));
            map.from(this::getReceiverQueueSize).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setReceiverQueueSize(arg_0));
            map.from(this::getAcknowledgementsGroupTime).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAcknowledgementsGroupTime(arg_0));
            map.from(this::getAcknowledgeAsynchronously).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAcknowledgeAsynchronously(arg_0));
            map.from(this::getAcknowledgeSchedulerType).as(scheduler -> switch (scheduler) {
                default -> throw new IncompatibleClassChangeError();
                case SchedulerType.boundedElastic -> Schedulers.boundedElastic();
                case SchedulerType.parallel -> Schedulers.parallel();
                case SchedulerType.single -> Schedulers.single();
                case SchedulerType.immediate -> Schedulers.immediate();
            }).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAcknowledgeScheduler(arg_0));
            map.from(this::getNegativeAckRedeliveryDelay).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setNegativeAckRedeliveryDelay(arg_0));
            map.from(this::getDeadLetterPolicy).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setDeadLetterPolicy(arg_0));
            map.from(this::getRetryLetterTopicEnable).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setRetryLetterTopicEnable(arg_0));
            map.from(this::getMaxTotalReceiverQueueSizeAcrossPartitions).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setMaxTotalReceiverQueueSizeAcrossPartitions(arg_0));
            map.from(this::getConsumerName).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setConsumerName(arg_0));
            map.from(this::getAckTimeout).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAckTimeout(arg_0));
            map.from(this::getAckTimeoutTickTime).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAckTimeoutTickTime(arg_0));
            map.from(this::getPriorityLevel).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setPriorityLevel(arg_0));
            map.from(this::getCryptoFailureAction).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setCryptoFailureAction(arg_0));
            map.from(this::getProperties).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setProperties(arg_0));
            map.from(this::getReadCompacted).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setReadCompacted(arg_0));
            map.from(this::getBatchIndexAckEnabled).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setBatchIndexAckEnabled(arg_0));
            map.from(this::getSubscriptionInitialPosition).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setSubscriptionInitialPosition(arg_0));
            map.from(this::getTopicsPatternAutoDiscoveryPeriod).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setTopicsPatternAutoDiscoveryPeriod(arg_0));
            map.from(this::getTopicsPatternSubscriptionMode).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setTopicsPatternSubscriptionMode(arg_0));
            map.from(this::getAutoUpdatePartitions).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAutoUpdatePartitions(arg_0));
            map.from(this::getAutoUpdatePartitionsInterval).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAutoUpdatePartitionsInterval(arg_0));
            map.from(this::getReplicateSubscriptionState).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setReplicateSubscriptionState(arg_0));
            map.from(this::getAutoAckOldestChunkedMessageOnQueueFull).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setAutoAckOldestChunkedMessageOnQueueFull(arg_0));
            map.from(this::getMaxPendingChunkedMessage).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setMaxPendingChunkedMessage(arg_0));
            map.from(this::getExpireTimeOfIncompleteChunkedMessage).to(arg_0 -> ((MutableReactiveMessageConsumerSpec)spec).setExpireTimeOfIncompleteChunkedMessage(arg_0));
            return new ImmutableReactiveMessageConsumerSpec((ReactiveMessageConsumerSpec)spec);
        }
    }

    public static class Reader {
        private String[] topicNames;
        private String readerName;
        private String subscriptionName;
        private String generatedSubscriptionNamePrefix;
        private Integer receiverQueueSize;
        private Boolean readCompacted;
        private Range[] keyHashRanges;
        private ConsumerCryptoFailureAction cryptoFailureAction;

        public String[] getTopicNames() {
            return this.topicNames;
        }

        public void setTopicNames(String[] topicNames) {
            this.topicNames = topicNames;
        }

        public String getReaderName() {
            return this.readerName;
        }

        public void setReaderName(String readerName) {
            this.readerName = readerName;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public String getGeneratedSubscriptionNamePrefix() {
            return this.generatedSubscriptionNamePrefix;
        }

        public void setGeneratedSubscriptionNamePrefix(String generatedSubscriptionNamePrefix) {
            this.generatedSubscriptionNamePrefix = generatedSubscriptionNamePrefix;
        }

        public Integer getReceiverQueueSize() {
            return this.receiverQueueSize;
        }

        public void setReceiverQueueSize(Integer receiverQueueSize) {
            this.receiverQueueSize = receiverQueueSize;
        }

        public Boolean getReadCompacted() {
            return this.readCompacted;
        }

        public void setReadCompacted(Boolean readCompacted) {
            this.readCompacted = readCompacted;
        }

        public Range[] getKeyHashRanges() {
            return this.keyHashRanges;
        }

        public void setKeyHashRanges(Range[] keyHashRanges) {
            this.keyHashRanges = keyHashRanges;
        }

        public ConsumerCryptoFailureAction getCryptoFailureAction() {
            return this.cryptoFailureAction;
        }

        public void setCryptoFailureAction(ConsumerCryptoFailureAction cryptoFailureAction) {
            this.cryptoFailureAction = cryptoFailureAction;
        }

        public ReactiveMessageReaderSpec buildReactiveMessageReaderSpec() {
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            MutableReactiveMessageReaderSpec spec = new MutableReactiveMessageReaderSpec();
            map.from(this::getTopicNames).as(List::of).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setTopicNames(arg_0));
            map.from(this::getReaderName).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setReaderName(arg_0));
            map.from(this::getSubscriptionName).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setSubscriptionName(arg_0));
            map.from(this::getGeneratedSubscriptionNamePrefix).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setGeneratedSubscriptionNamePrefix(arg_0));
            map.from(this::getReceiverQueueSize).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setReceiverQueueSize(arg_0));
            map.from(this::getReadCompacted).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setReadCompacted(arg_0));
            map.from(this::getKeyHashRanges).as(List::of).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setKeyHashRanges(arg_0));
            map.from(this::getCryptoFailureAction).to(arg_0 -> ((MutableReactiveMessageReaderSpec)spec).setCryptoFailureAction(arg_0));
            return new ImmutableReactiveMessageReaderSpec((ReactiveMessageReaderSpec)spec);
        }
    }

    public static class Listener {
        private SchemaType schemaType;
        private Duration handlingTimeout = Duration.ofMinutes(2L);
        private Boolean useKeyOrderedProcessing = false;

        public SchemaType getSchemaType() {
            return this.schemaType;
        }

        public void setSchemaType(SchemaType schemaType) {
            this.schemaType = schemaType;
        }

        public Duration getHandlingTimeout() {
            return this.handlingTimeout;
        }

        public void setHandlingTimeout(Duration handlingTimeout) {
            this.handlingTimeout = handlingTimeout;
        }

        public Boolean getUseKeyOrderedProcessing() {
            return this.useKeyOrderedProcessing;
        }

        public void setUseKeyOrderedProcessing(Boolean useKeyOrderedProcessing) {
            this.useKeyOrderedProcessing = useKeyOrderedProcessing;
        }
    }

    public static class Cache {
        private Duration expireAfterAccess = Duration.ofMinutes(1L);
        private Long maximumSize = 1000L;
        private Integer initialCapacity = 50;

        public Duration getExpireAfterAccess() {
            return this.expireAfterAccess;
        }

        public void setExpireAfterAccess(Duration expireAfterAccess) {
            this.expireAfterAccess = expireAfterAccess;
        }

        public Long getMaximumSize() {
            return this.maximumSize;
        }

        public void setMaximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
        }

        public Integer getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(Integer initialCapacity) {
            this.initialCapacity = initialCapacity;
        }
    }

    public static enum SchedulerType {
        boundedElastic,
        parallel,
        single,
        immediate;

    }
}

