/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.autoconfigure;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

enum WellKnownAuthParameters {
    TENANT_DOMAIN("tenantDomain"),
    TENANT_SERVICE("tenantService"),
    PROVIDER_DOMAIN("providerDomain"),
    PRIVATE_KEY("privateKey"),
    PRIVATE_KEY_PATH("privateKeyPath"),
    KEY_ID("keyId"),
    AUTO_PREFETCH_ENABLED("autoPrefetchEnabled"),
    ATHENZ_CONF_PATH("athenzConfPath"),
    PRINCIPAL_HEADER("principalHeader"),
    ROLE_HEADER("roleHeader"),
    ZTS_URL("ztsUrl"),
    USER_ID("userId"),
    PASSWORD("password"),
    KEY_STORE_TYPE("keyStoreType"),
    KEY_STORE_PATH("keyStorePath"),
    KEY_STORE_PASSWORD("keyStorePassword"),
    TYPE("type"),
    ISSUER_URL("issuerUrl"),
    AUDIENCE("audience"),
    SCOPE("scope"),
    SASL_JAAS_CLIENT_SECTION_NAME("saslJaasClientSectionName"),
    SERVER_TYPE("serverType"),
    TLS_CERT_FILE("tlsCertFile"),
    TLS_KEY_FILE("tlsKeyFile"),
    TOKEN("token");

    private static final Map<String, String> LOWER_CASE_TO_CAMEL_CASE;
    private final String camelCaseKey;

    private WellKnownAuthParameters(String camelCaseKey) {
        this.camelCaseKey = camelCaseKey;
    }

    String getCamelCaseKey() {
        return this.camelCaseKey;
    }

    public static String toCamelCaseKey(String lowerCaseKey) {
        return LOWER_CASE_TO_CAMEL_CASE.getOrDefault(lowerCaseKey, lowerCaseKey);
    }

    static {
        LOWER_CASE_TO_CAMEL_CASE = Arrays.stream(WellKnownAuthParameters.values()).map(WellKnownAuthParameters::getCamelCaseKey).collect(Collectors.toMap(String::toLowerCase, Function.identity()));
    }
}

