/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.client.api.PulsarClient;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.Nullable;

public class PulsarClientFactoryBean
extends AbstractFactoryBean<PulsarClient> {
    private final LogAccessor logger = new LogAccessor(((Object)((Object)this)).getClass());
    private final Map<String, Object> config = new HashMap<String, Object>();

    public PulsarClientFactoryBean(Map<String, Object> config) {
        Objects.requireNonNull(config, "Config map cannot be null");
        this.config.putAll(config);
    }

    public Class<?> getObjectType() {
        return PulsarClient.class;
    }

    protected PulsarClient createInstance() throws Exception {
        return PulsarClient.builder().loadConf(this.config).build();
    }

    protected void destroyInstance(@Nullable PulsarClient instance) throws Exception {
        if (instance != null) {
            this.logger.info(() -> "Closing client " + instance);
            instance.close();
        }
    }
}

