/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.client.api.Schema;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.PulsarReaderFactory;
import org.springframework.pulsar.core.ReaderBuilderCustomizer;
import org.springframework.util.CollectionUtils;

public class DefaultPulsarReaderFactory<T>
implements PulsarReaderFactory<T> {
    private final PulsarClient pulsarClient;
    private final Map<String, Object> readerConfig;

    public DefaultPulsarReaderFactory(PulsarClient pulsarClient) {
        this(pulsarClient, Collections.emptyMap());
    }

    public DefaultPulsarReaderFactory(PulsarClient pulsarClient, Map<String, Object> readerConfig) {
        this.pulsarClient = pulsarClient;
        this.readerConfig = readerConfig;
    }

    @Override
    public Reader<T> createReader(@Nullable List<String> topics, @Nullable MessageId messageId, Schema<T> schema, @Nullable List<ReaderBuilderCustomizer<T>> customizers) throws PulsarClientException {
        Objects.requireNonNull(schema, "Schema must be specified");
        ReaderBuilder readerBuilder = this.pulsarClient.newReader(schema);
        if (!CollectionUtils.isEmpty(topics)) {
            readerBuilder.topics(topics);
        }
        readerBuilder.startMessageId(messageId);
        readerBuilder.loadConf(this.readerConfig);
        if (!CollectionUtils.isEmpty(customizers)) {
            customizers.forEach(customizer -> customizer.customize(readerBuilder));
        }
        return readerBuilder.create();
    }
}

