/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import io.micrometer.observation.ObservationRegistry;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.springframework.lang.Nullable;
import org.springframework.pulsar.core.AbstractPulsarMessageContainer;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarRecordMessageListener;
import org.springframework.util.Assert;

public abstract class AbstractPulsarMessageListenerContainer<T>
extends AbstractPulsarMessageContainer
implements PulsarMessageListenerContainer {
    private final PulsarConsumerFactory<T> pulsarConsumerFactory;
    private final PulsarContainerProperties pulsarContainerProperties;
    private final ObservationRegistry observationRegistry;
    protected final Object lifecycleMonitor = new Object();
    private volatile boolean paused;
    protected RedeliveryBackoff negativeAckRedeliveryBackoff;
    protected RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    protected DeadLetterPolicy deadLetterPolicy;
    protected PulsarConsumerErrorHandler<T> pulsarConsumerErrorHandler;
    protected ConsumerBuilderCustomizer<T> consumerBuilderCustomizer;

    protected AbstractPulsarMessageListenerContainer(PulsarConsumerFactory<? super T> pulsarConsumerFactory, PulsarContainerProperties pulsarContainerProperties, @Nullable ObservationRegistry observationRegistry) {
        this.pulsarConsumerFactory = pulsarConsumerFactory;
        this.pulsarContainerProperties = pulsarContainerProperties;
        this.observationRegistry = observationRegistry;
    }

    public PulsarConsumerFactory<T> getPulsarConsumerFactory() {
        return this.pulsarConsumerFactory;
    }

    @Override
    public PulsarContainerProperties getContainerProperties() {
        return this.pulsarContainerProperties;
    }

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.pulsarContainerProperties.setMessageListener(messageListener);
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    @Override
    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                Assert.state((boolean)(this.pulsarContainerProperties.getMessageListener() instanceof PulsarRecordMessageListener), () -> "A " + PulsarRecordMessageListener.class.getName() + " implementation must be provided");
                this.doStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.doStop();
            }
        }
    }

    @Override
    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff redeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = redeliveryBackoff;
    }

    @Override
    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff redeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = redeliveryBackoff;
    }

    public RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public RedeliveryBackoff getAckTimeoutkRedeliveryBackoff() {
        return this.ackTimeoutRedeliveryBackoff;
    }

    @Override
    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public PulsarConsumerErrorHandler<T> getPulsarConsumerErrorHandler() {
        return this.pulsarConsumerErrorHandler;
    }

    @Override
    public void setPulsarConsumerErrorHandler(PulsarConsumerErrorHandler pulsarConsumerErrorHandler) {
        this.pulsarConsumerErrorHandler = pulsarConsumerErrorHandler;
    }

    @Override
    public void setConsumerCustomizer(ConsumerBuilderCustomizer<?> consumerBuilderCustomizer) {
        this.consumerBuilderCustomizer = consumerBuilderCustomizer;
    }

    public ConsumerBuilderCustomizer<T> getConsumerBuilderCustomizer() {
        return this.consumerBuilderCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.doResume();
        }
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
    }

    protected abstract void doPause();

    protected abstract void doResume();
}

