/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.annotation.PulsarMessage;
import org.springframework.util.Assert;

class PulsarMessageAnnotationRegistry {
    private static final int DEFAULT_MAX_CACHE_SIZE = 1000;
    private final int maxNumberOfAnnotationsCached;
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private ConcurrentHashMap<Class<?>, Optional<PulsarMessage>> annotationsByClass = new ConcurrentHashMap();

    PulsarMessageAnnotationRegistry() {
        this(1000);
    }

    PulsarMessageAnnotationRegistry(int maxNumberOfAnnotationsCached) {
        Assert.state((maxNumberOfAnnotationsCached > 0 ? 1 : 0) != 0, (String)"maxNumberOfAnnotationsCached must be > 0");
        this.maxNumberOfAnnotationsCached = maxNumberOfAnnotationsCached;
    }

    Optional<PulsarMessage> getAnnotationFor(Class<?> targetClass) {
        Optional annotation = this.annotationsByClass.computeIfAbsent(targetClass, this::findAnnotationOn);
        if (this.annotationsByClass.size() > this.maxNumberOfAnnotationsCached) {
            this.logger.info(() -> "Clearing cache - max entries exceeded (%d)".formatted(this.maxNumberOfAnnotationsCached));
            this.annotationsByClass = new ConcurrentHashMap();
        }
        return annotation;
    }

    protected Optional<PulsarMessage> findAnnotationOn(Class<?> targetClass) {
        this.logger.debug(() -> "Looking for @PulsarMessage on " + targetClass);
        PulsarMessage annotation = (PulsarMessage)AnnotationUtils.findAnnotation(targetClass, PulsarMessage.class);
        return Optional.ofNullable(annotation);
    }
}

