/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.client.api.SubscriptionType;
import org.springframework.pulsar.config.AbstractPulsarListenerContainerFactory;
import org.springframework.pulsar.config.PulsarListenerEndpoint;
import org.springframework.pulsar.core.PulsarConsumerFactory;
import org.springframework.pulsar.listener.AbstractPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConcurrentPulsarListenerContainerFactory<T>
extends AbstractPulsarListenerContainerFactory<ConcurrentPulsarMessageListenerContainer<T>, T> {
    private static final String SUBSCRIPTION_NAME_PREFIX = "org.springframework.Pulsar.PulsarListenerEndpointContainer#";
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public ConcurrentPulsarListenerContainerFactory(PulsarConsumerFactory<? super T> consumerFactory, PulsarContainerProperties containerProperties) {
        super(consumerFactory, containerProperties);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    public void setConcurrency(Integer concurrency) {
        this.getContainerProperties().setConcurrency(concurrency);
    }

    @Override
    public ConcurrentPulsarMessageListenerContainer<T> createContainer(final String ... topics) {
        PulsarListenerEndpoint endpoint = new PulsarListenerEndpoint(){

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        AbstractPulsarMessageListenerContainer container = this.createContainerInstance(endpoint);
        this.initializeContainer((ConcurrentPulsarMessageListenerContainer<T>)container, endpoint);
        return container;
    }

    @Override
    protected ConcurrentPulsarMessageListenerContainer<T> createContainerInstance(PulsarListenerEndpoint endpoint) {
        PulsarContainerProperties factoryProps = this.getContainerProperties();
        PulsarContainerProperties containerProps = new PulsarContainerProperties(new String[0]);
        containerProps.setConsumerTaskExecutor(factoryProps.getConsumerTaskExecutor());
        containerProps.setSchemaResolver(factoryProps.getSchemaResolver());
        containerProps.setTopicResolver(factoryProps.getTopicResolver());
        containerProps.setSubscriptionType(factoryProps.getSubscriptionType());
        containerProps.setSubscriptionName(factoryProps.getSubscriptionName());
        PulsarContainerProperties.TransactionSettings factoryTxnProps = factoryProps.transactions();
        PulsarContainerProperties.TransactionSettings containerTxnProps = containerProps.transactions();
        containerTxnProps.setEnabled(factoryTxnProps.isEnabled());
        containerTxnProps.setRequired(factoryTxnProps.isRequired());
        containerTxnProps.setTimeout(factoryTxnProps.getTimeout());
        containerTxnProps.setTransactionDefinition(factoryTxnProps.getTransactionDefinition());
        containerTxnProps.setTransactionManager(factoryTxnProps.getTransactionManager());
        if (!CollectionUtils.isEmpty(endpoint.getTopics())) {
            containerProps.setTopics(new HashSet<String>(endpoint.getTopics()));
        }
        if (StringUtils.hasText((String)endpoint.getTopicPattern())) {
            containerProps.setTopicsPattern(endpoint.getTopicPattern());
        }
        if (endpoint.isBatchListener()) {
            containerProps.setBatchListener(endpoint.isBatchListener());
        }
        if (StringUtils.hasText((String)endpoint.getSubscriptionName())) {
            containerProps.setSubscriptionName(endpoint.getSubscriptionName());
        }
        if (endpoint.getSubscriptionType() != null) {
            containerProps.setSubscriptionType(endpoint.getSubscriptionType());
        }
        if (!StringUtils.hasText((String)containerProps.getSubscriptionName())) {
            String generatedName = SUBSCRIPTION_NAME_PREFIX + COUNTER.getAndIncrement();
            containerProps.setSubscriptionName(generatedName);
        }
        if (containerProps.getSubscriptionType() == null) {
            containerProps.setSubscriptionType(SubscriptionType.Exclusive);
        }
        containerProps.setSchemaType(endpoint.getSchemaType());
        return new ConcurrentPulsarMessageListenerContainer(this.getConsumerFactory(), containerProps);
    }

    @Override
    protected void initializeContainer(ConcurrentPulsarMessageListenerContainer<T> instance, PulsarListenerEndpoint endpoint) {
        super.initializeContainer(instance, endpoint);
        if (endpoint.getConcurrency() != null) {
            instance.setConcurrency(endpoint.getConcurrency());
        } else if (this.getContainerProperties().getConcurrency() > 0) {
            instance.setConcurrency(this.getContainerProperties().getConcurrency());
        }
    }
}

