/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.function;

import java.util.Optional;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.springframework.core.log.LogAccessor;

public interface PulsarFunctionOperations<T> {
    public static final LogAccessor logger = new LogAccessor(PulsarFunctionOperations.class);

    public String name();

    public FunctionType type();

    public String archive();

    public FunctionStopPolicy stopPolicy();

    default public boolean functionExists(PulsarAdmin admin) throws PulsarAdminException {
        return this.getIfExists(admin).isPresent();
    }

    default public Optional<T> getIfExists(PulsarAdmin admin) throws PulsarAdminException {
        try {
            return Optional.of(this.get(admin));
        }
        catch (PulsarAdminException.NotFoundException ex) {
            logger.trace((Throwable)ex, () -> "Function not found: " + this.name());
            return Optional.empty();
        }
    }

    public T get(PulsarAdmin var1) throws PulsarAdminException;

    public void create(PulsarAdmin var1) throws PulsarAdminException;

    public void createWithUrl(PulsarAdmin var1) throws PulsarAdminException;

    public void update(PulsarAdmin var1) throws PulsarAdminException;

    public void updateWithUrl(PulsarAdmin var1) throws PulsarAdminException;

    public void stop(PulsarAdmin var1);

    public void delete(PulsarAdmin var1);

    public static enum FunctionStopPolicy {
        NONE,
        STOP,
        DELETE;

    }

    public static enum FunctionType {
        FUNCTION,
        SINK,
        SOURCE;

    }
}

