/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.listener;

import java.util.function.BiFunction;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.PulsarException;
import org.springframework.pulsar.core.PulsarOperations;
import org.springframework.pulsar.listener.PulsarMessageRecoverer;
import org.springframework.pulsar.listener.PulsarMessageRecovererFactory;

public class PulsarDeadLetterPublishingRecoverer<T>
implements PulsarMessageRecovererFactory<T> {
    protected final LogAccessor logger = new LogAccessor(this.getClass());
    public static final String EXCEPTION_THROWN_CAUSE = "exception-thrown-cause";
    private static final BiFunction<Consumer<?>, Message<?>, String> DEFAULT_DESTINATION_RESOLVER = (c, m) -> m.getTopicName() + "-" + c.getSubscription() + "-DLT";
    private final PulsarOperations<T> pulsarTemplate;
    private final BiFunction<Consumer<?>, Message<?>, String> destinationResolver;

    public PulsarDeadLetterPublishingRecoverer(PulsarOperations<T> pulsarTemplate) {
        this(pulsarTemplate, DEFAULT_DESTINATION_RESOLVER);
    }

    public PulsarDeadLetterPublishingRecoverer(PulsarOperations<T> pulsarTemplate, BiFunction<Consumer<?>, Message<?>, String> destinationResolver) {
        this.pulsarTemplate = pulsarTemplate;
        this.destinationResolver = destinationResolver;
    }

    @Override
    public PulsarMessageRecoverer<T> recovererForConsumer(Consumer<T> consumer) {
        return (message, exception) -> {
            try {
                this.pulsarTemplate.newMessage(message.getValue()).withTopic(this.destinationResolver.apply(consumer, message)).withMessageCustomizer(messageBuilder -> messageBuilder.property(EXCEPTION_THROWN_CAUSE, exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage())).sendAsync();
            }
            catch (PulsarException e) {
                this.logger.error((Throwable)((Object)e), (CharSequence)"DLT publishing failed.");
            }
        };
    }
}

