/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.support.internal.logging;

import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.core.ProducerBuilderCustomizer;
import org.springframework.pulsar.support.JavaUtils;
import org.springframework.pulsar.support.internal.logging.EveryNthSampler;
import org.springframework.util.Assert;

public class LambdaCustomizerWarnLogger {
    private static final String CUSTOMIZER_LAMBDA_MSG = "Producer customizer [%s] is implemented as a Lambda. If you are experiencing write performance degradation\nit may be related to cache misses if the lambda is not following the rules outlined in\nhttps://docs.spring.io/spring-pulsar/reference/reference/pulsar/message-production.html#producer-caching-lambdas";
    private final LogAccessor logger;
    private final EveryNthSampler<String> logSampler;

    public LambdaCustomizerWarnLogger(LogAccessor logger, long frequency) {
        Assert.notNull((Object)logger, (String)"logger must not be null");
        this.logger = logger;
        this.logSampler = new EveryNthSampler(frequency, 500L);
    }

    public void maybeLog(ProducerBuilderCustomizer<?> producerCustomizer) {
        Class<?> customizerClass = producerCustomizer.getClass();
        if (JavaUtils.INSTANCE.isLambda(customizerClass) && this.logSampler.trySample(customizerClass.getName())) {
            this.logger.warn(() -> CUSTOMIZER_LAMBDA_MSG.formatted(customizerClass.getName()));
        }
    }
}

