/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.annotation;

import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.pulsar.config.ConcurrentPulsarListenerContainerFactory;
import org.springframework.pulsar.config.ConcurrentPulsarListenerContainerFactoryCustomizer;
import org.springframework.util.CollectionUtils;

class ConcurrentPulsarListenerContainerFactoryBeanCustomizerPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private @Nullable ApplicationContext applicationContext;

    ConcurrentPulsarListenerContainerFactoryBeanCustomizerPostProcessor() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof ConcurrentPulsarListenerContainerFactory) {
            ConcurrentPulsarListenerContainerFactory containerFactory = (ConcurrentPulsarListenerContainerFactory)bean;
            Map customizers = Objects.requireNonNull(this.applicationContext, "applicationContext must not be null").getBeansOfType(ConcurrentPulsarListenerContainerFactoryCustomizer.class);
            if (CollectionUtils.isEmpty((Map)customizers)) {
                return bean;
            }
            if (customizers.size() > 1) {
                this.logger.warn((CharSequence)"Found multiple %s beans [%s] - must be only 1 in order to apply".formatted(ConcurrentPulsarListenerContainerFactoryCustomizer.class.getSimpleName(), customizers.keySet()));
            } else {
                customizers.values().forEach(c -> c.customize(containerFactory));
            }
        }
        return bean;
    }
}

