/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.pulsar.config.PulsarReaderEndpoint;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractPulsarReaderEndpoint<K>
implements PulsarReaderEndpoint<PulsarMessageReaderContainer>,
BeanFactoryAware,
InitializingBean {
    private @Nullable String subscriptionName;
    private SchemaType schemaType = SchemaType.NONE;
    private @Nullable String id;
    private final List<String> topics = new ArrayList<String>();
    private @Nullable MessageId startMessageId;
    private @Nullable BeanFactory beanFactory;
    private @Nullable BeanExpressionResolver resolver;
    private @Nullable BeanExpressionContext expressionContext;
    private @Nullable BeanResolver beanResolver;
    private @Nullable Boolean autoStartup;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), null);
        }
        this.beanResolver = new BeanFactoryResolver(beanFactory);
    }

    protected @Nullable BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getTopics().isEmpty()) {
            throw new IllegalStateException("Topics or topicPattern must be provided but not both for " + String.valueOf(this));
        }
    }

    protected @Nullable BeanExpressionResolver getResolver() {
        return this.resolver;
    }

    protected @Nullable BeanExpressionContext getBeanExpressionContext() {
        return this.expressionContext;
    }

    protected @Nullable BeanResolver getBeanResolver() {
        return this.beanResolver;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public @Nullable String getId() {
        return this.id;
    }

    public void setTopics(String ... topics) {
        Assert.notNull((Object)topics, (String)"'topics' must not be null");
        this.topics.clear();
        this.topics.addAll(Arrays.asList(topics));
    }

    @Override
    public List<String> getTopics() {
        return Collections.unmodifiableList(this.topics);
    }

    @Override
    public @Nullable Boolean getAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(@Nullable Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public void setupListenerContainer(PulsarMessageReaderContainer listenerContainer, @Nullable MessageConverter messageConverter) {
        this.setupMessageListener(listenerContainer, messageConverter);
    }

    private void setupMessageListener(PulsarMessageReaderContainer container, @Nullable MessageConverter messageConverter) {
        AbstractPulsarMessageToSpringMessageAdapter<K> adapter = this.createReaderListener(container, messageConverter);
        AbstractPulsarMessageToSpringMessageAdapter<K> messageListener = adapter;
        Assert.state((messageListener != null ? 1 : 0) != 0, () -> "Endpoint [" + String.valueOf(this) + "] must provide a non null message listener");
        container.setupReaderListener(messageListener);
    }

    protected abstract AbstractPulsarMessageToSpringMessageAdapter<K> createReaderListener(PulsarMessageReaderContainer var1, @Nullable MessageConverter var2);

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    @Override
    public @Nullable MessageId getStartMessageId() {
        return this.startMessageId;
    }

    public void setStartMessageId(@Nullable MessageId startMessageId) {
        this.startMessageId = startMessageId;
    }
}

