/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.pulsar.config.PulsarReaderEndpoint;
import org.springframework.pulsar.config.ReaderContainerFactory;
import org.springframework.pulsar.reader.PulsarMessageReaderContainer;
import org.springframework.pulsar.reader.PulsarReaderContainerRegistry;
import org.springframework.util.Assert;

public class GenericReaderEndpointRegistry<C extends PulsarMessageReaderContainer, E extends PulsarReaderEndpoint<C>>
implements PulsarReaderContainerRegistry,
DisposableBean,
SmartLifecycle,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    private final Class<? extends C> type;
    private final Map<String, C> readerContainers = new ConcurrentHashMap<String, C>();
    private final ReentrantLock containersLock = new ReentrantLock();
    private @Nullable ConfigurableApplicationContext applicationContext;
    private int phase = Integer.MAX_VALUE;
    private boolean contextRefreshed;
    private volatile boolean running;

    protected GenericReaderEndpointRegistry(Class<?> type) {
        this.type = type;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    protected ApplicationContext getRequiredApplicationContext() {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext must be set");
        return this.applicationContext;
    }

    public @Nullable C getReaderContainer(String id) {
        Assert.hasText((String)id, (String)"Container identifier must not be empty");
        return (C)((PulsarMessageReaderContainer)this.readerContainers.get(id));
    }

    @Override
    public Set<String> getReaderContainerIds() {
        return Collections.unmodifiableSet(this.readerContainers.keySet());
    }

    public Collection<C> getReaderContainers() {
        return Collections.unmodifiableCollection(this.readerContainers.values());
    }

    public Collection<C> getAllReaderContainers() {
        ArrayList<C> containers = new ArrayList<C>(this.getReaderContainers());
        containers.addAll(this.getRequiredApplicationContext().getBeansOfType(this.type, true, false).values());
        return containers;
    }

    public void registerReaderContainer(E endpoint, ReaderContainerFactory<? extends C, E> factory) {
        this.registerReaderContainer(endpoint, factory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReaderContainer(E endpoint, ReaderContainerFactory<? extends C, E> factory, boolean startImmediately) {
        Assert.notNull(endpoint, (String)"Endpoint must not be null");
        Assert.notNull(factory, (String)"Factory must not be null");
        String id = endpoint.getId();
        Assert.hasText((String)id, (String)"Endpoint id must not be empty");
        this.containersLock.lock();
        try {
            Assert.state((!this.readerContainers.containsKey(id) ? 1 : 0) != 0, (String)("Another endpoint is already registered with id '" + id + "'"));
            C container = this.createReaderContainer(endpoint, factory);
            this.readerContainers.put(id, container);
        }
        finally {
            this.containersLock.unlock();
        }
    }

    protected C createReaderContainer(E endpoint, ReaderContainerFactory<? extends C, E> factory) {
        PulsarMessageReaderContainer readerContainer = (PulsarMessageReaderContainer)factory.createRegisteredContainer(endpoint);
        if (readerContainer instanceof InitializingBean) {
            try {
                ((InitializingBean)readerContainer).afterPropertiesSet();
            }
            catch (Exception ex) {
                throw new BeanInitializationException("Failed to initialize message listener container", (Throwable)ex);
            }
        }
        int containerPhase = readerContainer.getPhase();
        if (readerContainer.isAutoStartup() && containerPhase != Integer.MAX_VALUE) {
            if (this.phase != Integer.MAX_VALUE && this.phase != containerPhase) {
                throw new IllegalStateException("Encountered phase mismatch between container factory definitions: " + this.phase + " vs " + containerPhase);
            }
            this.phase = readerContainer.getPhase();
        }
        return (C)readerContainer;
    }

    public void destroy() throws Exception {
        for (PulsarMessageReaderContainer listenerContainer : this.getReaderContainers()) {
            listenerContainer.destroy();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void start() {
        for (PulsarMessageReaderContainer listenerContainer : this.getReaderContainers()) {
            this.startIfNecessary(listenerContainer);
        }
        this.running = true;
    }

    public void stop() {
        this.running = false;
        for (PulsarMessageReaderContainer listenerContainer : this.getReaderContainers()) {
            listenerContainer.stop();
        }
    }

    public void stop(Runnable callback) {
        this.running = false;
        Collection<C> readerContainersToStop = this.getReaderContainers();
        if (readerContainersToStop.size() > 0) {
            AggregatingCallback aggregatingCallback = new AggregatingCallback(readerContainersToStop.size(), callback);
            for (PulsarMessageReaderContainer readerContainer : readerContainersToStop) {
                if (readerContainer.isRunning()) {
                    readerContainer.stop(aggregatingCallback);
                    continue;
                }
                aggregatingCallback.run();
            }
        } else {
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (event.getApplicationContext().equals(this.getRequiredApplicationContext())) {
            this.contextRefreshed = true;
        }
    }

    private void startIfNecessary(C listenerContainer) {
        if (this.contextRefreshed || listenerContainer.isAutoStartup()) {
            listenerContainer.start();
        }
    }

    private static final class AggregatingCallback
    implements Runnable {
        private final AtomicInteger count;
        private final Runnable finishCallback;

        private AggregatingCallback(int count, Runnable finishCallback) {
            this.count = new AtomicInteger(count);
            this.finishCallback = finishCallback;
        }

        @Override
        public void run() {
            if (this.count.decrementAndGet() <= 0) {
                this.finishCallback.run();
            }
        }
    }
}

