/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.RedeliveryBackoff;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.pulsar.config.AbstractPulsarListenerEndpoint;
import org.springframework.pulsar.core.ConsumerBuilderCustomizer;
import org.springframework.pulsar.core.SchemaResolver;
import org.springframework.pulsar.core.TopicResolver;
import org.springframework.pulsar.listener.Acknowledgement;
import org.springframework.pulsar.listener.ConcurrentPulsarMessageListenerContainer;
import org.springframework.pulsar.listener.PulsarConsumerErrorHandler;
import org.springframework.pulsar.listener.PulsarContainerProperties;
import org.springframework.pulsar.listener.PulsarMessageListenerContainer;
import org.springframework.pulsar.listener.adapter.AbstractPulsarMessageToSpringMessageAdapter;
import org.springframework.pulsar.listener.adapter.HandlerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarBatchMessagesToSpringMessageListenerAdapter;
import org.springframework.pulsar.listener.adapter.PulsarRecordMessageToSpringMessageListenerAdapter;
import org.springframework.pulsar.support.MessageConverter;
import org.springframework.pulsar.support.converter.PulsarMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MethodPulsarListenerEndpoint<V>
extends AbstractPulsarListenerEndpoint<V> {
    private final LogAccessor logger = new LogAccessor(this.getClass());
    private @Nullable Object bean;
    private @Nullable Method method;
    private @Nullable ObjectMapper objectMapper;
    private @Nullable MessageHandlerMethodFactory messageHandlerMethodFactory;
    private @Nullable SmartMessageConverter messagingConverter;
    private @Nullable RedeliveryBackoff negativeAckRedeliveryBackoff;
    private @Nullable RedeliveryBackoff ackTimeoutRedeliveryBackoff;
    private @Nullable DeadLetterPolicy deadLetterPolicy;
    private @Nullable PulsarConsumerErrorHandler pulsarConsumerErrorHandler;
    private @Nullable ConsumerBuilderCustomizer<?> consumerBuilderCustomizer;
    private @Nullable Boolean transactional;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public @Nullable Object getBean() {
        return this.bean;
    }

    protected Object requireNonNullBean() {
        Assert.notNull((Object)this.bean, (String)"Bean must not be null");
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public @Nullable Method getMethod() {
        return this.method;
    }

    protected Method requireNonNullMethod() {
        Assert.notNull((Object)this.method, (String)"Method must not be null");
        return this.method;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    protected MessageHandlerMethodFactory requireNonNullMessageHandlerMethodFactory() {
        Assert.notNull((Object)this.messageHandlerMethodFactory, (String)"The messageHandlerMethodFactory must not be null");
        return this.messageHandlerMethodFactory;
    }

    @Override
    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListener(PulsarMessageListenerContainer container, @Nullable MessageConverter messageConverter) {
        boolean hasTopicInfo;
        SchemaInfo schemaInfo;
        MessageHandlerMethodFactory messageHandlerMethodFactory = this.requireNonNullMessageHandlerMethodFactory();
        AbstractPulsarMessageToSpringMessageAdapter<V> messageListener = this.createMessageListenerInstance(messageConverter);
        HandlerAdapter handlerMethod = this.configureListenerAdapter(messageListener, messageHandlerMethodFactory);
        messageListener.setHandlerMethod(handlerMethod);
        MethodParameter[] methodParameters = handlerMethod.requireNonNullInvokerHandlerMethod().getMethodParameters();
        List<MethodParameter> allPayloadParams = Arrays.stream(methodParameters).filter(param -> !param.getParameterType().equals(Consumer.class) && !param.getParameterType().equals(Acknowledgement.class) && !param.hasParameterAnnotation(Header.class)).toList();
        Assert.isTrue((allPayloadParams.size() == 1 ? 1 : 0) != 0, (String)("Expected 1 payload types but found " + String.valueOf(allPayloadParams)));
        MethodParameter messageParameter = (MethodParameter)allPayloadParams.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to determine message parameter"));
        ConcurrentPulsarMessageListenerContainer containerInstance = (ConcurrentPulsarMessageListenerContainer)container;
        PulsarContainerProperties pulsarContainerProperties = containerInstance.getContainerProperties();
        SchemaResolver schemaResolver = pulsarContainerProperties.getSchemaResolver();
        Assert.notNull((Object)schemaResolver, (String)"schemaResolver must be set on container properties");
        SchemaType schemaType = pulsarContainerProperties.getSchemaType();
        Assert.notNull((Object)schemaType, (String)"schemaType must be set on container properties");
        ResolvableType messageType = this.resolvableType(messageParameter);
        schemaResolver.resolveSchema(schemaType, messageType).ifResolvedOrElse(pulsarContainerProperties::setSchema, ex -> this.logger.warn(() -> "Failed to resolve schema for type %s - will default to BYTES (due to: %s)".formatted(schemaType, ex.getMessage())));
        if (pulsarContainerProperties.getSchema() != null && (schemaInfo = pulsarContainerProperties.getSchema().getSchemaInfo()) != null) {
            pulsarContainerProperties.setSchemaType(schemaInfo.getType());
        }
        TopicResolver topicResolver = pulsarContainerProperties.getTopicResolver();
        Assert.notNull((Object)topicResolver, (String)"topicResolver must be set on container properties");
        boolean bl = hasTopicInfo = !ObjectUtils.isEmpty(pulsarContainerProperties.getTopics()) || StringUtils.hasText((String)pulsarContainerProperties.getTopicsPattern());
        if (!hasTopicInfo) {
            topicResolver.resolveTopic((String)null, messageType.getRawClass(), () -> null).ifResolved(topic -> pulsarContainerProperties.setTopics(Set.of(topic)));
        }
        this.validateAndAdjustTransactionSettings(pulsarContainerProperties.transactions());
        container.setNegativeAckRedeliveryBackoff(this.negativeAckRedeliveryBackoff);
        container.setAckTimeoutRedeliveryBackoff(this.ackTimeoutRedeliveryBackoff);
        container.setDeadLetterPolicy(this.deadLetterPolicy);
        container.setPulsarConsumerErrorHandler(this.pulsarConsumerErrorHandler);
        container.setConsumerCustomizer(this.consumerBuilderCustomizer);
        return messageListener;
    }

    private void validateAndAdjustTransactionSettings(PulsarContainerProperties.TransactionSettings txnProps) {
        if (this.transactional == null) {
            return;
        }
        Assert.state((!txnProps.isRequired() || this.transactional != false ? 1 : 0) != 0, (String)"Listener w/ id [%s] requested no transactions but txn are required".formatted(this.getId()));
        if (!this.transactional.booleanValue()) {
            this.logger.debug(() -> "Listener w/ id [%s] requested no transactions".formatted(this.getId()));
            txnProps.setEnabled(false);
        } else if (txnProps.getTransactionManager() == null) {
            this.logger.warn(() -> "Listener w/ id [%s] requested transactions but no txn mgr available".formatted(this.getId()));
        } else {
            txnProps.setEnabled(true);
        }
    }

    private ResolvableType resolvableType(MethodParameter methodParameter) {
        ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)methodParameter);
        Class rawClass = resolvableType.getRawClass();
        if (rawClass != null && this.isContainerType(rawClass)) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        if (resolvableType.getRawClass() != null && (Message.class.isAssignableFrom(resolvableType.getRawClass()) || org.springframework.messaging.Message.class.isAssignableFrom(resolvableType.getRawClass()))) {
            resolvableType = resolvableType.getGeneric(new int[]{0});
        }
        return resolvableType;
    }

    private boolean isContainerType(Class<?> rawClass) {
        return rawClass.isAssignableFrom(List.class) || rawClass.isAssignableFrom(Message.class) || rawClass.isAssignableFrom(Messages.class) || rawClass.isAssignableFrom(org.springframework.messaging.Message.class);
    }

    protected HandlerAdapter configureListenerAdapter(AbstractPulsarMessageToSpringMessageAdapter<V> messageListener, MessageHandlerMethodFactory messageHandlerMethodFactory) {
        InvocableHandlerMethod invocableHandlerMethod = messageHandlerMethodFactory.createInvocableHandlerMethod(this.requireNonNullBean(), this.requireNonNullMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected AbstractPulsarMessageToSpringMessageAdapter<V> createMessageListenerInstance(@Nullable MessageConverter messageConverter) {
        BeanResolver resolver;
        AbstractPulsarMessageToSpringMessageAdapter listener = this.isBatchListener() ? new PulsarBatchMessagesToSpringMessageListenerAdapter(this.requireNonNullBean(), this.requireNonNullMethod()) : new PulsarRecordMessageToSpringMessageListenerAdapter(this.requireNonNullBean(), this.requireNonNullMethod());
        if (messageConverter instanceof PulsarMessageConverter) {
            PulsarMessageConverter pulsarMessageConverter = (PulsarMessageConverter)messageConverter;
            listener.setMessageConverter(pulsarMessageConverter);
        }
        if (this.messagingConverter != null) {
            listener.setMessagingConverter(this.messagingConverter);
        }
        if (this.objectMapper != null) {
            listener.setObjectMapper(this.objectMapper);
        }
        if ((resolver = this.getBeanResolver()) != null) {
            listener.setBeanResolver(resolver);
        }
        return listener;
    }

    public void setMessagingConverter(SmartMessageConverter messagingConverter) {
        this.messagingConverter = messagingConverter;
    }

    public void setNegativeAckRedeliveryBackoff(RedeliveryBackoff negativeAckRedeliveryBackoff) {
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy deadLetterPolicy) {
        this.deadLetterPolicy = deadLetterPolicy;
    }

    public void setPulsarConsumerErrorHandler(PulsarConsumerErrorHandler pulsarConsumerErrorHandler) {
        this.pulsarConsumerErrorHandler = pulsarConsumerErrorHandler;
    }

    public void setAckTimeoutRedeliveryBackoff(RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
    }

    public @Nullable ConsumerBuilderCustomizer<?> getConsumerBuilderCustomizer() {
        return this.consumerBuilderCustomizer;
    }

    public void setConsumerBuilderCustomizer(ConsumerBuilderCustomizer<?> consumerBuilderCustomizer) {
        this.consumerBuilderCustomizer = consumerBuilderCustomizer;
    }

    public @Nullable Boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(@Nullable Boolean transactional) {
        this.transactional = transactional;
    }
}

