/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.core;

import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public final class Resolved<T> {
    private final @Nullable T value;
    private final @Nullable RuntimeException exception;

    private Resolved(@Nullable T value, @Nullable RuntimeException exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <T> Resolved<T> of(@Nullable T value) {
        return new Resolved<T>(value, null);
    }

    public static <T> Resolved<T> failed(String reason) {
        return new Resolved<Object>(null, new IllegalArgumentException(reason));
    }

    public static <T> Resolved<T> failed(RuntimeException reason) {
        return new Resolved<Object>(null, reason);
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public Optional<T> get() {
        return this.value();
    }

    public Optional<T> value() {
        return Optional.ofNullable(this.value);
    }

    public Optional<RuntimeException> exception() {
        return Optional.ofNullable(this.exception);
    }

    public void ifResolved(Consumer<? super T> action) {
        if (this.value != null && this.exception == null) {
            action.accept(this.value);
        }
    }

    public void ifResolvedOrElse(Consumer<? super T> action, Consumer<RuntimeException> errorAction) {
        if (this.value != null && this.exception == null) {
            action.accept(this.value);
        } else if (this.exception != null) {
            errorAction.accept(this.exception);
        }
    }

    public @Nullable T orElseThrow() {
        if (this.value == null && this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public @Nullable T orElseThrow(Supplier<String> wrappingErrorMessage) {
        if (this.value == null && this.exception != null) {
            throw new RuntimeException(wrappingErrorMessage.get(), this.exception);
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resolved resolved = (Resolved)o;
        return Objects.equals(this.value, resolved.value) && Objects.equals(this.exception, resolved.exception);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.exception);
    }

    public String toString() {
        return new StringJoiner(", ", Resolved.class.getSimpleName() + "[", "]").add("value=" + String.valueOf(this.value)).add("exception=" + String.valueOf(this.exception)).toString();
    }
}

