/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.restassured;

import com.jayway.restassured.response.Cookie;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.MultiPartSpecification;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

class RestAssuredRequestConverter
implements RequestConverter<FilterableRequestSpecification> {
    RestAssuredRequestConverter() {
    }

    public OperationRequest convert(FilterableRequestSpecification requestSpec) {
        return new OperationRequestFactory().create(URI.create(requestSpec.getURI()), HttpMethod.valueOf((String)requestSpec.getMethod().name()), this.extractContent(requestSpec), this.extractHeaders(requestSpec), this.extractParameters(requestSpec), this.extractParts(requestSpec), this.extractCookies(requestSpec));
    }

    private Collection<RequestCookie> extractCookies(FilterableRequestSpecification requestSpec) {
        ArrayList<RequestCookie> cookies = new ArrayList<RequestCookie>();
        for (Cookie cookie : requestSpec.getCookies()) {
            cookies.add(new RequestCookie(cookie.getName(), cookie.getValue()));
        }
        return cookies;
    }

    private byte[] extractContent(FilterableRequestSpecification requestSpec) {
        return this.convertContent(requestSpec.getBody());
    }

    private byte[] convertContent(Object content) {
        if (content instanceof String) {
            return ((String)content).getBytes();
        }
        if (content instanceof byte[]) {
            return (byte[])content;
        }
        if (content instanceof File) {
            return this.copyToByteArray((File)content);
        }
        if (content instanceof InputStream) {
            return this.copyToByteArray((InputStream)content);
        }
        if (content == null) {
            return new byte[0];
        }
        throw new IllegalStateException("Unsupported request content: " + content.getClass().getName());
    }

    private byte[] copyToByteArray(File file) {
        try {
            return FileCopyUtils.copyToByteArray((File)file);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read content from file " + file, ex);
        }
    }

    private byte[] copyToByteArray(InputStream inputStream) {
        try {
            inputStream.reset();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read content from input stream " + inputStream + " due to reset() failure");
        }
        try {
            return StreamUtils.copyToByteArray((InputStream)inputStream);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read content from input stream " + inputStream, ex);
        }
    }

    private HttpHeaders extractHeaders(FilterableRequestSpecification requestSpec) {
        HttpHeaders httpHeaders = new HttpHeaders();
        for (Header header : requestSpec.getHeaders()) {
            if (this.isAllMediaTypesAcceptHeader(header)) continue;
            httpHeaders.add(header.getName(), header.getValue());
        }
        return httpHeaders;
    }

    private boolean isAllMediaTypesAcceptHeader(Header header) {
        return "Accept".equals(header.getName()) && "*/*".equals(header.getValue());
    }

    private Parameters extractParameters(FilterableRequestSpecification requestSpec) {
        Parameters parameters = new Parameters();
        for (Map.Entry entry : requestSpec.getQueryParams().entrySet()) {
            if (entry.getValue() instanceof Collection) {
                Collection queryParams = (Collection)entry.getValue();
                for (Object queryParam : queryParams) {
                    parameters.add(entry.getKey(), (Object)queryParam.toString());
                }
                continue;
            }
            parameters.add(entry.getKey(), (Object)entry.getValue().toString());
        }
        for (Map.Entry entry : requestSpec.getRequestParams().entrySet()) {
            parameters.add(entry.getKey(), (Object)entry.getValue().toString());
        }
        for (Map.Entry entry : requestSpec.getFormParams().entrySet()) {
            parameters.add(entry.getKey(), (Object)entry.getValue().toString());
        }
        return parameters;
    }

    private Collection<OperationRequestPart> extractParts(FilterableRequestSpecification requestSpec) {
        ArrayList<OperationRequestPart> parts = new ArrayList<OperationRequestPart>();
        for (MultiPartSpecification multiPartSpec : requestSpec.getMultiPartParams()) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(multiPartSpec.getMimeType() == null ? MediaType.TEXT_PLAIN : MediaType.parseMediaType((String)multiPartSpec.getMimeType()));
            parts.add(new OperationRequestPartFactory().create(multiPartSpec.getControlName(), multiPartSpec.getFileName(), this.convertContent(multiPartSpec.getContent()), headers));
        }
        return parts;
    }
}

