/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.webtestclient;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.FormHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import org.springframework.restdocs.operation.OperationRequest;
import org.springframework.restdocs.operation.OperationRequestFactory;
import org.springframework.restdocs.operation.OperationRequestPart;
import org.springframework.restdocs.operation.OperationRequestPartFactory;
import org.springframework.restdocs.operation.Parameters;
import org.springframework.restdocs.operation.QueryStringParser;
import org.springframework.restdocs.operation.RequestConverter;
import org.springframework.restdocs.operation.RequestCookie;
import org.springframework.test.web.reactive.server.ExchangeResult;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

class WebTestClientRequestConverter
implements RequestConverter<ExchangeResult> {
    private static final ResolvableType FORM_DATA_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, (Class[])new Class[]{String.class, String.class});
    private final QueryStringParser queryStringParser = new QueryStringParser();
    private final FormHttpMessageReader formDataReader = new FormHttpMessageReader();

    WebTestClientRequestConverter() {
    }

    public OperationRequest convert(ExchangeResult result) {
        HttpHeaders headers = this.extractRequestHeaders(result);
        return new OperationRequestFactory().create(result.getUrl(), result.getMethod(), result.getRequestBodyContent(), headers, this.extractParameters(result), this.extractRequestParts(result), this.extractCookies(headers));
    }

    private HttpHeaders extractRequestHeaders(ExchangeResult result) {
        HttpHeaders extracted = new HttpHeaders();
        extracted.putAll((Map)result.getRequestHeaders());
        extracted.remove((Object)"WebTestClient-Request-Id");
        return extracted;
    }

    private Parameters extractParameters(ExchangeResult result) {
        if (result.getMethod() == HttpMethod.GET) {
            return this.queryStringParser.parse(result.getUrl());
        }
        Parameters parameters = new Parameters();
        if (result.getRequestHeaders().getContentType().equals((Object)MediaType.APPLICATION_FORM_URLENCODED)) {
            parameters.addAll((MultiValueMap)this.formDataReader.readMono(FORM_DATA_TYPE, (ReactiveHttpInputMessage)new ExchangeResultReactiveHttpInputMessage(result), null).block());
        }
        return parameters;
    }

    private List<OperationRequestPart> extractRequestParts(ExchangeResult result) {
        if (!ClassUtils.isPresent((String)"org.synchronoss.cloud.nio.multipart.NioMultipartParserListener", (ClassLoader)this.getClass().getClassLoader())) {
            return Collections.emptyList();
        }
        return ((MultiValueMap)new MultipartHttpMessageReader((HttpMessageReader)new SynchronossPartHttpMessageReader()).readMono(null, (ReactiveHttpInputMessage)new ExchangeResultReactiveHttpInputMessage(result), null).onErrorReturn((Object)new LinkedMultiValueMap()).block()).values().stream().flatMap(parts -> parts.stream().map(this::createOperationRequestPart)).collect(Collectors.toList());
    }

    private OperationRequestPart createOperationRequestPart(Part part) {
        ByteArrayOutputStream content = this.readPartBodyContent(part);
        return new OperationRequestPartFactory().create(part.name(), part instanceof FilePart ? ((FilePart)part).filename() : null, content.toByteArray(), part.headers());
    }

    private ByteArrayOutputStream readPartBodyContent(Part part) {
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        DataBufferUtils.write((Publisher)part.content(), (OutputStream)contentStream).blockFirst();
        return contentStream;
    }

    private Collection<RequestCookie> extractCookies(HttpHeaders headers) {
        List cookieHeaders = headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return Collections.emptyList();
        }
        headers.remove((Object)"Cookie");
        return cookieHeaders.stream().map(this::createRequestCookie).collect(Collectors.toList());
    }

    private RequestCookie createRequestCookie(String header) {
        String[] components = header.split("=");
        return new RequestCookie(components[0], components[1]);
    }

    private final class ExchangeResultReactiveHttpInputMessage
    implements ReactiveHttpInputMessage {
        private final ExchangeResult result;

        private ExchangeResultReactiveHttpInputMessage(ExchangeResult result) {
            this.result = result;
        }

        public HttpHeaders getHeaders() {
            return this.result.getRequestHeaders();
        }

        public Flux<DataBuffer> getBody() {
            DefaultDataBuffer buffer = new DefaultDataBufferFactory().allocateBuffer();
            buffer.write(this.result.getRequestBodyContent());
            return Flux.fromArray((Object[])new DataBuffer[]{buffer});
        }
    }
}

