/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.OperationNotSupportedException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.CircuitBreaker;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.RecoverAnnotationRecoveryHandler;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.BackOffPolicyBuilder;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.backoff.Sleeper;
import org.springframework.retry.interceptor.FixedKeyGenerator;
import org.springframework.retry.interceptor.MethodArgumentsKeyGenerator;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.NewMethodArgumentsIdentifier;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.policy.CircuitBreakerRetryPolicy;
import org.springframework.retry.policy.ExpressionRetryPolicy;
import org.springframework.retry.policy.MapRetryContextCache;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.Args;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AnnotationAwareRetryOperationsInterceptor
implements IntroductionInterceptor,
BeanFactoryAware {
    private static final TemplateParserContext PARSER_CONTEXT = new TemplateParserContext();
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final MethodInterceptor NULL_INTERCEPTOR = methodInvocation -> {
        throw new OperationNotSupportedException("Not supported");
    };
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private final ConcurrentReferenceHashMap<Object, ConcurrentMap<Method, MethodInterceptor>> delegates = new ConcurrentReferenceHashMap();
    private RetryContextCache retryContextCache = new MapRetryContextCache();
    private MethodArgumentsKeyGenerator methodArgumentsKeyGenerator;
    private NewMethodArgumentsIdentifier newMethodArgumentsIdentifier;
    private Sleeper sleeper;
    private BeanFactory beanFactory;
    private RetryListener[] globalListeners;

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public void setKeyGenerator(MethodArgumentsKeyGenerator methodArgumentsKeyGenerator) {
        this.methodArgumentsKeyGenerator = methodArgumentsKeyGenerator;
    }

    public void setNewItemIdentifier(NewMethodArgumentsIdentifier newMethodArgumentsIdentifier) {
        this.newMethodArgumentsIdentifier = newMethodArgumentsIdentifier;
    }

    public void setListeners(Collection<RetryListener> globalListeners) {
        ArrayList<RetryListener> retryListeners = new ArrayList<RetryListener>(globalListeners);
        AnnotationAwareOrderComparator.sort(retryListeners);
        this.globalListeners = retryListeners.toArray(new RetryListener[0]);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
    }

    public boolean implementsInterface(Class<?> intf) {
        return org.springframework.retry.interceptor.Retryable.class.isAssignableFrom(intf);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        MethodInterceptor delegate = this.getDelegate(invocation.getThis(), invocation.getMethod());
        if (delegate != null) {
            return delegate.invoke(invocation);
        }
        return invocation.proceed();
    }

    private MethodInterceptor getDelegate(Object target, Method method) {
        MethodInterceptor delegate;
        ConcurrentHashMap<Method, MethodInterceptor> cachedMethods = (ConcurrentHashMap<Method, MethodInterceptor>)this.delegates.get(target);
        if (cachedMethods == null) {
            cachedMethods = new ConcurrentHashMap<Method, MethodInterceptor>();
        }
        if ((delegate = (MethodInterceptor)cachedMethods.get(method)) == null) {
            MethodInterceptor interceptor = NULL_INTERCEPTOR;
            Retryable retryable = (Retryable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Retryable.class);
            if (retryable == null) {
                retryable = this.classLevelAnnotation(method, Retryable.class);
            }
            if (retryable == null) {
                retryable = this.findAnnotationOnTarget(target, method, Retryable.class);
            }
            if (retryable != null) {
                interceptor = StringUtils.hasText((String)retryable.interceptor()) ? (MethodInterceptor)this.beanFactory.getBean(retryable.interceptor(), MethodInterceptor.class) : (retryable.stateful() ? this.getStatefulInterceptor(target, method, retryable) : this.getStatelessInterceptor(target, method, retryable));
            }
            cachedMethods.putIfAbsent(method, interceptor);
            delegate = (MethodInterceptor)cachedMethods.get(method);
        }
        this.delegates.putIfAbsent(target, cachedMethods);
        return delegate == NULL_INTERCEPTOR ? null : delegate;
    }

    private <A extends Annotation> A findAnnotationOnTarget(Object target, Method method, Class<A> annotation) {
        try {
            Method targetMethod = target.getClass().getMethod(method.getName(), method.getParameterTypes());
            Annotation retryable = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)targetMethod, annotation);
            if (retryable == null) {
                retryable = this.classLevelAnnotation(targetMethod, annotation);
            }
            return (A)retryable;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <A extends Annotation> A classLevelAnnotation(Method method, Class<A> annotation) {
        Annotation ann = AnnotatedElementUtils.findMergedAnnotation(method.getDeclaringClass(), annotation);
        if (ann != null && AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Recover.class) != null) {
            ann = null;
        }
        return (A)ann;
    }

    private MethodInterceptor getStatelessInterceptor(Object target, Method method, Retryable retryable) {
        RetryTemplate template = this.createTemplate(retryable.listeners());
        template.setRetryPolicy(this.getRetryPolicy(retryable, true));
        template.setBackOffPolicy(this.getBackoffPolicy(retryable.backoff(), true));
        return RetryInterceptorBuilder.stateless().retryOperations(template).label(retryable.label()).recoverer(this.getRecoverer(target, method)).build();
    }

    private MethodInterceptor getStatefulInterceptor(Object target, Method method, Retryable retryable) {
        RetryTemplate template = this.createTemplate(retryable.listeners());
        template.setRetryContextCache(this.retryContextCache);
        CircuitBreaker circuit = (CircuitBreaker)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, CircuitBreaker.class);
        if (circuit == null) {
            circuit = this.findAnnotationOnTarget(target, method, CircuitBreaker.class);
        }
        if (circuit != null) {
            RetryPolicy policy = this.getRetryPolicy(circuit, false);
            CircuitBreakerRetryPolicy breaker = new CircuitBreakerRetryPolicy(policy);
            this.openTimeout(breaker, circuit);
            this.resetTimeout(breaker, circuit);
            template.setRetryPolicy(breaker);
            template.setBackOffPolicy(new NoBackOffPolicy());
            String label = circuit.label();
            if (!StringUtils.hasText((String)label)) {
                label = method.toGenericString();
            }
            return RetryInterceptorBuilder.circuitBreaker().keyGenerator(new FixedKeyGenerator("circuit")).retryOperations(template).recoverer((MethodInvocationRecoverer)this.getRecoverer(target, method)).label(label).build();
        }
        RetryPolicy policy = this.getRetryPolicy(retryable, false);
        template.setRetryPolicy(policy);
        template.setBackOffPolicy(this.getBackoffPolicy(retryable.backoff(), false));
        String label = retryable.label();
        return RetryInterceptorBuilder.stateful().keyGenerator(this.methodArgumentsKeyGenerator).newMethodArgumentsIdentifier(this.newMethodArgumentsIdentifier).retryOperations(template).label(label).recoverer(this.getRecoverer(target, method)).build();
    }

    private void openTimeout(CircuitBreakerRetryPolicy breaker, CircuitBreaker circuit) {
        String expression = circuit.openTimeoutExpression();
        if (StringUtils.hasText((String)expression)) {
            Expression parsed = this.parse(expression);
            if (this.isTemplate(expression)) {
                Long value = (Long)parsed.getValue((EvaluationContext)this.evaluationContext, Long.class);
                if (value != null) {
                    breaker.setOpenTimeout(value);
                    return;
                }
            } else {
                breaker.openTimeoutSupplier(() -> this.evaluate(parsed, Long.class, false));
                return;
            }
        }
        breaker.setOpenTimeout(circuit.openTimeout());
    }

    private void resetTimeout(CircuitBreakerRetryPolicy breaker, CircuitBreaker circuit) {
        String expression = circuit.resetTimeoutExpression();
        if (StringUtils.hasText((String)expression)) {
            Expression parsed = this.parse(expression);
            if (this.isTemplate(expression)) {
                Long value = (Long)parsed.getValue((EvaluationContext)this.evaluationContext, Long.class);
                if (value != null) {
                    breaker.setResetTimeout(value);
                    return;
                }
            } else {
                breaker.resetTimeoutSupplier(() -> this.evaluate(parsed, Long.class, false));
            }
        }
        breaker.setResetTimeout(circuit.resetTimeout());
    }

    private RetryTemplate createTemplate(String[] listenersBeanNames) {
        RetryTemplate template = new RetryTemplate();
        if (listenersBeanNames.length > 0) {
            template.setListeners(this.getListenersBeans(listenersBeanNames));
        } else if (this.globalListeners != null) {
            template.setListeners(this.globalListeners);
        }
        return template;
    }

    private RetryListener[] getListenersBeans(String[] listenersBeanNames) {
        if (listenersBeanNames.length == 1 && "".equals(listenersBeanNames[0].trim())) {
            return new RetryListener[0];
        }
        RetryListener[] listeners = new RetryListener[listenersBeanNames.length];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (RetryListener)this.beanFactory.getBean(listenersBeanNames[i], RetryListener.class);
        }
        return listeners;
    }

    private MethodInvocationRecoverer<?> getRecoverer(Object target, Method method) {
        if (target instanceof MethodInvocationRecoverer) {
            return (MethodInvocationRecoverer)target;
        }
        AtomicBoolean foundRecoverable = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(target.getClass(), candidate -> {
            if (AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)candidate, Recover.class) != null) {
                foundRecoverable.set(true);
            }
        });
        if (!foundRecoverable.get()) {
            return null;
        }
        return new RecoverAnnotationRecoveryHandler(target, method);
    }

    private RetryPolicy getRetryPolicy(Annotation retryable, boolean stateless) {
        Class[] noRecovery;
        boolean retryNotExcluded;
        Map attrs = AnnotationUtils.getAnnotationAttributes((Annotation)retryable);
        Class[] includes = (Class[])attrs.get("value");
        String exceptionExpression = (String)attrs.get("exceptionExpression");
        boolean hasExceptionExpression = StringUtils.hasText((String)exceptionExpression);
        if (includes.length == 0) {
            Class[] value;
            includes = value = (Class[])attrs.get("retryFor");
        }
        Class[] excludes = (Class[])attrs.get("noRetryFor");
        Integer maxAttempts = (Integer)attrs.get("maxAttempts");
        String maxAttemptsExpression = (String)attrs.get("maxAttemptsExpression");
        Expression parsedExpression = null;
        if (StringUtils.hasText((String)maxAttemptsExpression)) {
            parsedExpression = this.parse(maxAttemptsExpression);
            if (this.isTemplate(maxAttemptsExpression)) {
                maxAttempts = (Integer)parsedExpression.getValue((EvaluationContext)this.evaluationContext, Integer.class);
                parsedExpression = null;
            }
        }
        Expression maxAttExpression = parsedExpression;
        SimpleRetryPolicy simple = null;
        if (includes.length == 0 && excludes.length == 0) {
            SimpleRetryPolicy simpleRetryPolicy = simple = hasExceptionExpression ? new ExpressionRetryPolicy(this.resolve(exceptionExpression)).withBeanFactory(this.beanFactory) : new SimpleRetryPolicy();
            if (maxAttExpression != null) {
                simple.maxAttemptsSupplier(() -> this.evaluate(maxAttExpression, Integer.class, stateless));
            } else {
                simple.setMaxAttempts(maxAttempts);
            }
        }
        HashMap<Class<? extends Throwable>, Boolean> policyMap = new HashMap<Class<? extends Throwable>, Boolean>();
        for (Class type : includes) {
            policyMap.put(type, true);
        }
        for (Class type : excludes) {
            policyMap.put(type, false);
        }
        boolean bl = retryNotExcluded = includes.length == 0;
        if (simple == null) {
            simple = hasExceptionExpression ? new ExpressionRetryPolicy(maxAttempts, policyMap, true, this.resolve(exceptionExpression), retryNotExcluded).withBeanFactory(this.beanFactory) : new SimpleRetryPolicy(maxAttempts, policyMap, true, retryNotExcluded);
            if (maxAttExpression != null) {
                simple.maxAttemptsSupplier(() -> this.evaluate(maxAttExpression, Integer.class, stateless));
            }
        }
        if ((noRecovery = (Class[])attrs.get("notRecoverable")) != null && noRecovery.length > 0) {
            simple.setNotRecoverable(noRecovery);
        }
        return simple;
    }

    private BackOffPolicy getBackoffPolicy(Backoff backoff, boolean stateless) {
        Map attrs = AnnotationUtils.getAnnotationAttributes((Annotation)backoff);
        long min = backoff.delay() == 0L ? backoff.value() : backoff.delay();
        String delayExpression = (String)attrs.get("delayExpression");
        Expression parsedMinExp = null;
        if (StringUtils.hasText((String)delayExpression)) {
            parsedMinExp = this.parse(delayExpression);
            if (this.isTemplate(delayExpression)) {
                min = (Long)parsedMinExp.getValue((EvaluationContext)this.evaluationContext, Long.class);
                parsedMinExp = null;
            }
        }
        long max = backoff.maxDelay();
        String maxDelayExpression = (String)attrs.get("maxDelayExpression");
        Expression parsedMaxExp = null;
        if (StringUtils.hasText((String)maxDelayExpression)) {
            parsedMaxExp = this.parse(maxDelayExpression);
            if (this.isTemplate(maxDelayExpression)) {
                max = (Long)parsedMaxExp.getValue((EvaluationContext)this.evaluationContext, Long.class);
                parsedMaxExp = null;
            }
        }
        double multiplier = backoff.multiplier();
        String multiplierExpression = (String)attrs.get("multiplierExpression");
        Expression parsedMultExp = null;
        if (StringUtils.hasText((String)multiplierExpression)) {
            parsedMultExp = this.parse(multiplierExpression);
            if (this.isTemplate(multiplierExpression)) {
                multiplier = (Double)parsedMultExp.getValue((EvaluationContext)this.evaluationContext, Double.class);
                parsedMultExp = null;
            }
        }
        boolean isRandom = false;
        String randomExpression = (String)attrs.get("randomExpression");
        Expression parsedRandomExp = null;
        if (multiplier > 0.0) {
            isRandom = backoff.random();
            if (StringUtils.hasText((String)randomExpression)) {
                parsedRandomExp = this.parse(randomExpression);
                if (this.isTemplate(randomExpression)) {
                    isRandom = (Boolean)parsedRandomExp.getValue((EvaluationContext)this.evaluationContext, Boolean.class);
                    parsedRandomExp = null;
                }
            }
        }
        return this.buildBackOff(min, parsedMinExp, max, parsedMaxExp, multiplier, parsedMultExp, isRandom, parsedRandomExp, stateless);
    }

    private BackOffPolicy buildBackOff(long min, Expression minExp, long max, Expression maxExp, double multiplier, Expression multExp, boolean isRandom, Expression randomExp, boolean stateless) {
        BackOffPolicyBuilder builder = BackOffPolicyBuilder.newBuilder();
        if (minExp != null) {
            builder.delaySupplier(() -> this.evaluate(minExp, Long.class, stateless));
        } else {
            builder.delay(min);
        }
        if (maxExp != null) {
            builder.maxDelaySupplier(() -> this.evaluate(maxExp, Long.class, stateless));
        } else {
            builder.maxDelay(max);
        }
        if (multExp != null) {
            builder.multiplierSupplier(() -> this.evaluate(multExp, Double.class, stateless));
        } else {
            builder.multiplier(multiplier);
        }
        if (randomExp != null) {
            builder.randomSupplier(() -> this.evaluate(randomExp, Boolean.class, stateless));
        } else {
            builder.random(isRandom);
        }
        builder.sleeper(this.sleeper);
        return builder.build();
    }

    private Expression parse(String expression) {
        if (this.isTemplate(expression)) {
            return PARSER.parseExpression(this.resolve(expression), (ParserContext)PARSER_CONTEXT);
        }
        return PARSER.parseExpression(this.resolve(expression));
    }

    private boolean isTemplate(String expression) {
        return expression.contains(PARSER_CONTEXT.getExpressionPrefix()) && expression.contains(PARSER_CONTEXT.getExpressionSuffix());
    }

    private <T> T evaluate(Expression expression, Class<T> type, boolean stateless) {
        Args args = null;
        if (stateless) {
            RetryContext context = RetrySynchronizationManager.getContext();
            if (context != null) {
                args = (Args)context.getAttribute("ARGS");
            }
            if (args == null) {
                args = Args.NO_ARGS;
            }
        }
        return (T)expression.getValue((EvaluationContext)this.evaluationContext, args, type);
    }

    private String resolve(String value) {
        if (this.beanFactory != null && this.beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
        }
        return value;
    }
}

