/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.web.configuration;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.OAuth2RequestValidator;
import org.springframework.security.oauth2.provider.TokenGranter;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.endpoint.AuthorizationEndpoint;
import org.springframework.security.oauth2.provider.endpoint.CheckTokenEndpoint;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpointHandlerMapping;
import org.springframework.security.oauth2.provider.endpoint.TokenEndpoint;
import org.springframework.security.oauth2.provider.endpoint.TokenKeyEndpoint;
import org.springframework.security.oauth2.provider.endpoint.WhitelabelApprovalEndpoint;
import org.springframework.security.oauth2.provider.endpoint.WhitelabelErrorEndpoint;
import org.springframework.security.oauth2.provider.implicit.ImplicitGrantService;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

@Configuration
@Import(value={TokenKeyEndpointRegistrar.class})
public class AuthorizationServerEndpointsConfiguration {
    public static final String TOKEN_STORE_BEAN_NAME = "tokenStore";
    private AuthorizationServerEndpointsConfigurer endpoints = new AuthorizationServerEndpointsConfigurer();
    @Autowired
    private ClientDetailsService clientDetailsService;
    @Autowired
    private List<AuthorizationServerConfigurer> configurers = Collections.emptyList();

    @PostConstruct
    public void init() throws Exception {
        for (AuthorizationServerConfigurer configurer : this.configurers) {
            configurer.configure(this.endpoints);
        }
        this.endpoints.clientDetailsService(this.clientDetailsService);
    }

    @Bean
    public AuthorizationEndpoint authorizationEndpoint() throws Exception {
        AuthorizationEndpoint authorizationEndpoint = new AuthorizationEndpoint();
        FrameworkEndpointHandlerMapping mapping = this.endpoints.getFrameworkEndpointHandlerMapping();
        authorizationEndpoint.setUserApprovalPage(this.extractPath(mapping, "/oauth/confirm_access"));
        authorizationEndpoint.setErrorPage(this.extractPath(mapping, "/oauth/error"));
        authorizationEndpoint.setTokenGranter(this.tokenGranter());
        authorizationEndpoint.setClientDetailsService(this.clientDetailsService);
        authorizationEndpoint.setAuthorizationCodeServices(this.authorizationCodeServices());
        authorizationEndpoint.setOAuth2RequestFactory(this.oauth2RequestFactory());
        authorizationEndpoint.setOAuth2RequestValidator(this.oauth2RequestValidator());
        authorizationEndpoint.setUserApprovalHandler(this.userApprovalHandler());
        authorizationEndpoint.setImplicitGrantService(this.implicitGrantService());
        return authorizationEndpoint;
    }

    @Bean
    public TokenEndpoint tokenEndpoint() throws Exception {
        TokenEndpoint tokenEndpoint = new TokenEndpoint();
        tokenEndpoint.setClientDetailsService(this.clientDetailsService);
        tokenEndpoint.setTokenGranter(this.tokenGranter());
        tokenEndpoint.setOAuth2RequestFactory(this.oauth2RequestFactory());
        tokenEndpoint.setOAuth2RequestValidator(this.oauth2RequestValidator());
        return tokenEndpoint;
    }

    @Bean
    public CheckTokenEndpoint checkTokenEndpoint() {
        CheckTokenEndpoint endpoint = new CheckTokenEndpoint(this.endpoints.getResourceServerTokenServices());
        endpoint.setAccessTokenConverter(this.endpoints.getAccessTokenConverter());
        return endpoint;
    }

    @Bean
    public WhitelabelApprovalEndpoint whitelabelApprovalEndpoint() {
        return new WhitelabelApprovalEndpoint();
    }

    @Bean
    public WhitelabelErrorEndpoint whitelabelErrorEndpoint() {
        return new WhitelabelErrorEndpoint();
    }

    @Bean
    public FrameworkEndpointHandlerMapping oauth2EndpointHandlerMapping() throws Exception {
        return this.endpoints.getFrameworkEndpointHandlerMapping();
    }

    @Bean
    public ConsumerTokenServices consumerTokenServices() throws Exception {
        return this.endpoints.getConsumerTokenServices();
    }

    @Bean
    public TokenStore tokenStore() throws Exception {
        return this.endpoints.getTokenStore();
    }

    private ImplicitGrantService implicitGrantService() throws Exception {
        return this.endpoints.getImplicitGrantService();
    }

    private OAuth2RequestFactory oauth2RequestFactory() throws Exception {
        return this.endpoints.getOAuth2RequestFactory();
    }

    private UserApprovalHandler userApprovalHandler() throws Exception {
        return this.endpoints.getUserApprovalHandler();
    }

    private OAuth2RequestValidator oauth2RequestValidator() throws Exception {
        return this.endpoints.getOAuth2RequestValidator();
    }

    private AuthorizationCodeServices authorizationCodeServices() throws Exception {
        return this.endpoints.getAuthorizationCodeServices();
    }

    private TokenGranter tokenGranter() throws Exception {
        return this.endpoints.getTokenGranter();
    }

    private String extractPath(FrameworkEndpointHandlerMapping mapping, String page) {
        String path = mapping.getPath(page);
        if (path.contains(":")) {
            return path;
        }
        return "forward:" + path;
    }

    @Configuration
    protected static class TokenKeyEndpointRegistrar
    implements BeanDefinitionRegistryPostProcessor {
        private BeanDefinitionRegistry registry;

        protected TokenKeyEndpointRegistrar() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            String[] names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, JwtAccessTokenConverter.class);
            if (names.length > 0) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(TokenKeyEndpoint.class);
                builder.addConstructorArgReference(names[0]);
                this.registry.registerBeanDefinition(TokenKeyEndpoint.class.getName(), (BeanDefinition)builder.getBeanDefinition());
            }
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            this.registry = registry;
        }
    }
}

