/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.authentication;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class OAuth2AuthenticationDetails
implements Serializable {
    private static final long serialVersionUID = -4809832298438307309L;
    public static final String ACCESS_TOKEN_VALUE = String.valueOf(OAuth2AuthenticationDetails.class.getSimpleName()) + ".ACCESS_TOKEN_VALUE";
    private final String remoteAddress;
    private final String sessionId;
    private final String tokenValue;
    private final String display;

    public OAuth2AuthenticationDetails(HttpServletRequest request) {
        this.tokenValue = (String)request.getAttribute(ACCESS_TOKEN_VALUE);
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(false);
        this.sessionId = session != null ? session.getId() : null;
        StringBuilder builder = new StringBuilder();
        if (this.remoteAddress != null) {
            builder.append("remoteAddress=").append(this.remoteAddress);
        }
        if (builder.length() > 1) {
            builder.append(", ");
        }
        if (this.sessionId != null) {
            builder.append("sessionId=<SESSION>");
            if (builder.length() > 1) {
                builder.append(", ");
            }
        }
        if (this.tokenValue != null) {
            builder.append("tokenValue=<TOKEN>");
        }
        this.display = builder.toString();
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        return this.display;
    }
}

