/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.xml;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.security.oauth2.provider.client.InMemoryClientDetailsService;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ClientDetailsServiceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return InMemoryClientDetailsService.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        List clientElements = DomUtils.getChildElementsByTagName((Element)element, (String)"client");
        ManagedMap clients = new ManagedMap();
        for (Element clientElement : clientElements) {
            String refreshValidity;
            BeanDefinitionBuilder client = BeanDefinitionBuilder.rootBeanDefinition(BaseClientDetails.class);
            String clientId = clientElement.getAttribute("client-id");
            if (StringUtils.hasText((String)clientId)) {
                client.addConstructorArgValue((Object)clientId);
            } else {
                parserContext.getReaderContext().error("A client id must be supplied with the definition of a client.", (Object)clientElement);
            }
            String secret = clientElement.getAttribute("secret");
            if (StringUtils.hasText((String)secret)) {
                client.addPropertyValue("clientSecret", (Object)secret);
            }
            String resourceIds = clientElement.getAttribute("resource-ids");
            if (StringUtils.hasText((String)clientId)) {
                client.addConstructorArgValue((Object)resourceIds);
            } else {
                client.addConstructorArgValue((Object)"");
            }
            String redirectUri = clientElement.getAttribute("redirect-uri");
            String tokenValidity = clientElement.getAttribute("access-token-validity");
            if (StringUtils.hasText((String)tokenValidity)) {
                client.addPropertyValue("accessTokenValiditySeconds", (Object)tokenValidity);
            }
            if (StringUtils.hasText((String)(refreshValidity = clientElement.getAttribute("refresh-token-validity")))) {
                client.addPropertyValue("refreshTokenValiditySeconds", (Object)refreshValidity);
            }
            client.addConstructorArgValue((Object)clientElement.getAttribute("scope"));
            client.addConstructorArgValue((Object)clientElement.getAttribute("authorized-grant-types"));
            client.addConstructorArgValue((Object)clientElement.getAttribute("authorities"));
            if (StringUtils.hasText((String)redirectUri)) {
                client.addConstructorArgValue((Object)redirectUri);
            }
            client.addPropertyValue("autoApproveScopes", (Object)clientElement.getAttribute("autoapprove"));
            clients.put((Object)clientId, (Object)client.getBeanDefinition());
        }
        builder.addPropertyValue("clientDetailsStore", (Object)clients);
    }
}

