/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultUserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;

public class DefaultAccessTokenConverter
implements AccessTokenConverter {
    private UserAuthenticationConverter userTokenConverter = new DefaultUserAuthenticationConverter();
    private boolean includeGrantType;
    private String scopeAttribute = "scope";
    private String clientIdAttribute = "client_id";

    public void setUserTokenConverter(UserAuthenticationConverter userTokenConverter) {
        this.userTokenConverter = userTokenConverter;
    }

    public void setIncludeGrantType(boolean includeGrantType) {
        this.includeGrantType = includeGrantType;
    }

    public void setScopeAttribute(String scopeAttribute) {
        this.scopeAttribute = scopeAttribute;
    }

    public void setClientIdAttribute(String clientIdAttribute) {
        this.clientIdAttribute = clientIdAttribute;
    }

    @Override
    public Map<String, ?> convertAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        OAuth2Request clientToken = authentication.getOAuth2Request();
        if (!authentication.isClientOnly()) {
            response.putAll(this.userTokenConverter.convertUserAuthentication(authentication.getUserAuthentication()));
        } else if (clientToken.getAuthorities() != null && !clientToken.getAuthorities().isEmpty()) {
            response.put("authorities", AuthorityUtils.authorityListToSet(clientToken.getAuthorities()));
        }
        if (token.getScope() != null) {
            response.put(this.scopeAttribute, token.getScope());
        }
        if (token.getAdditionalInformation().containsKey("jti")) {
            response.put("jti", token.getAdditionalInformation().get("jti"));
        }
        if (token.getExpiration() != null) {
            response.put("exp", token.getExpiration().getTime() / 1000L);
        }
        if (this.includeGrantType && authentication.getOAuth2Request().getGrantType() != null) {
            response.put("grant_type", authentication.getOAuth2Request().getGrantType());
        }
        response.putAll(token.getAdditionalInformation());
        response.put(this.clientIdAttribute, clientToken.getClientId());
        if (clientToken.getResourceIds() != null && !clientToken.getResourceIds().isEmpty()) {
            response.put("aud", clientToken.getResourceIds());
        }
        return response;
    }

    @Override
    public OAuth2AccessToken extractAccessToken(String value, Map<String, ?> map) {
        DefaultOAuth2AccessToken token = new DefaultOAuth2AccessToken(value);
        HashMap<String, Object> info = new HashMap<String, Object>(map);
        info.remove("exp");
        info.remove("aud");
        info.remove(this.clientIdAttribute);
        info.remove(this.scopeAttribute);
        if (map.containsKey("exp")) {
            token.setExpiration(new Date((Long)map.get("exp") * 1000L));
        }
        if (map.containsKey("jti")) {
            info.put("jti", map.get("jti"));
        }
        token.setScope(this.extractScope(map));
        token.setAdditionalInformation(info);
        return token;
    }

    @Override
    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set<String> scope = this.extractScope(map);
        Authentication user = this.userTokenConverter.extractAuthentication(map);
        String clientId = (String)map.get(this.clientIdAttribute);
        parameters.put(this.clientIdAttribute, clientId);
        if (this.includeGrantType && map.containsKey("grant_type")) {
            parameters.put("grant_type", (String)map.get("grant_type"));
        }
        LinkedHashSet<String> resourceIds = new LinkedHashSet<String>(map.containsKey("aud") ? this.getAudience(map) : Collections.emptySet());
        List authorities = null;
        if (user == null && map.containsKey("authorities")) {
            String[] roles = ((Collection)map.get("authorities")).toArray(new String[0]);
            authorities = AuthorityUtils.createAuthorityList((String[])roles);
        }
        OAuth2Request request = new OAuth2Request(parameters, clientId, authorities, true, scope, resourceIds, null, null, null);
        return new OAuth2Authentication(request, user);
    }

    private Collection<String> getAudience(Map<String, ?> map) {
        Object auds = map.get("aud");
        if (auds instanceof Collection) {
            Collection result = (Collection)auds;
            return result;
        }
        return Collections.singleton((String)auds);
    }

    private Set<String> extractScope(Map<String, ?> map) {
        Set<String> scope = Collections.emptySet();
        if (map.containsKey(this.scopeAttribute)) {
            Object scopeObj = map.get(this.scopeAttribute);
            if (String.class.isInstance(scopeObj)) {
                scope = new LinkedHashSet<String>(Arrays.asList(((String)String.class.cast(scopeObj)).split(" ")));
            } else if (Collection.class.isAssignableFrom(scopeObj.getClass())) {
                Collection scopeColl = (Collection)scopeObj;
                scope = new LinkedHashSet<String>(scopeColl);
            }
        }
        return scope;
    }
}

