/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public class EhCacheBasedAclCache
implements AclCache {
    private final Ehcache cache;
    private PermissionGrantingStrategy permissionGrantingStrategy;
    private AclAuthorizationStrategy aclAuthorizationStrategy;

    public EhCacheBasedAclCache(Ehcache cache, PermissionGrantingStrategy permissionGrantingStrategy, AclAuthorizationStrategy aclAuthorizationStrategy) {
        Assert.notNull((Object)cache, (String)"Cache required");
        Assert.notNull((Object)permissionGrantingStrategy, (String)"PermissionGrantingStrategy required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        this.cache = cache;
        this.permissionGrantingStrategy = permissionGrantingStrategy;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    @Override
    public void evictFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        MutableAcl acl = this.getFromCache(pk);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    @Override
    public void evictFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        MutableAcl acl = this.getFromCache(objectIdentity);
        if (acl != null) {
            this.cache.remove(acl.getId());
            this.cache.remove((Serializable)acl.getObjectIdentity());
        }
    }

    @Override
    public MutableAcl getFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        try {
            Element element = this.cache.get((Serializable)objectIdentity);
            return element != null ? this.initializeTransientFields((MutableAcl)element.getValue()) : null;
        }
        catch (CacheException ex) {
            return null;
        }
    }

    @Override
    public MutableAcl getFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        try {
            Element element = this.cache.get(pk);
            return element != null ? this.initializeTransientFields((MutableAcl)element.getValue()) : null;
        }
        catch (CacheException ex) {
            return null;
        }
    }

    @Override
    public void putInCache(MutableAcl acl) {
        Assert.notNull((Object)acl, (String)"Acl required");
        Assert.notNull((Object)acl.getObjectIdentity(), (String)"ObjectIdentity required");
        Assert.notNull((Object)acl.getId(), (String)"ID required");
        if (this.aclAuthorizationStrategy == null && acl instanceof AclImpl) {
            this.aclAuthorizationStrategy = (AclAuthorizationStrategy)FieldUtils.getProtectedFieldValue((String)"aclAuthorizationStrategy", (Object)acl);
            this.permissionGrantingStrategy = (PermissionGrantingStrategy)FieldUtils.getProtectedFieldValue((String)"permissionGrantingStrategy", (Object)acl);
        }
        if (acl.getParentAcl() != null && acl.getParentAcl() instanceof MutableAcl) {
            this.putInCache((MutableAcl)acl.getParentAcl());
        }
        this.cache.put(new Element((Serializable)acl.getObjectIdentity(), (Serializable)acl));
        this.cache.put(new Element(acl.getId(), (Serializable)acl));
    }

    private MutableAcl initializeTransientFields(MutableAcl value) {
        if (value instanceof AclImpl) {
            FieldUtils.setProtectedFieldValue((String)"aclAuthorizationStrategy", (Object)value, (Object)this.aclAuthorizationStrategy);
            FieldUtils.setProtectedFieldValue((String)"permissionGrantingStrategy", (Object)value, (Object)this.permissionGrantingStrategy);
        }
        if (value.getParentAcl() != null) {
            this.initializeTransientFields((MutableAcl)value.getParentAcl());
        }
        return value;
    }

    @Override
    public void clearCache() {
        this.cache.removeAll();
    }
}

