/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.jdbc.AclClassIdUtils;
import org.springframework.security.acls.jdbc.LookupStrategy;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityGenerator;
import org.springframework.security.acls.model.Sid;
import org.springframework.util.Assert;

public class JdbcAclService
implements AclService {
    protected static final Log log = LogFactory.getLog(JdbcAclService.class);
    private static final String DEFAULT_SELECT_ACL_CLASS_COLUMNS = "class.class as class";
    private static final String DEFAULT_SELECT_ACL_CLASS_COLUMNS_WITH_ID_TYPE = "class.class as class, class.class_id_type as class_id_type";
    private static final String DEFAULT_SELECT_ACL_WITH_PARENT_SQL = "select obj.object_id_identity as obj_id, class.class as class from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ? and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)";
    private static final String DEFAULT_SELECT_ACL_WITH_PARENT_SQL_WITH_CLASS_ID_TYPE = "select obj.object_id_identity as obj_id, class.class as class, class.class_id_type as class_id_type from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ? and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)";
    protected final JdbcOperations jdbcOperations;
    private final LookupStrategy lookupStrategy;
    private boolean aclClassIdSupported;
    private String findChildrenSql = "select obj.object_id_identity as obj_id, class.class as class from acl_object_identity obj, acl_object_identity parent, acl_class class where obj.parent_object = parent.id and obj.object_id_class = class.id and parent.object_id_identity = ? and parent.object_id_class = (select id FROM acl_class where acl_class.class = ?)";
    private AclClassIdUtils aclClassIdUtils;
    private ObjectIdentityGenerator objectIdentityGenerator;

    public JdbcAclService(DataSource dataSource, LookupStrategy lookupStrategy) {
        this((JdbcOperations)new JdbcTemplate(dataSource), lookupStrategy);
    }

    public JdbcAclService(JdbcOperations jdbcOperations, LookupStrategy lookupStrategy) {
        Assert.notNull((Object)jdbcOperations, (String)"JdbcOperations required");
        Assert.notNull((Object)lookupStrategy, (String)"LookupStrategy required");
        this.jdbcOperations = jdbcOperations;
        this.lookupStrategy = lookupStrategy;
        this.aclClassIdUtils = new AclClassIdUtils();
        this.objectIdentityGenerator = new ObjectIdentityRetrievalStrategyImpl();
    }

    @Override
    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        Object[] args = new Object[]{parentIdentity.getIdentifier().toString(), parentIdentity.getType()};
        List objects = this.jdbcOperations.query(this.findChildrenSql, args, (rs, rowNum) -> this.mapObjectIdentityRow(rs));
        return !objects.isEmpty() ? objects : null;
    }

    private ObjectIdentity mapObjectIdentityRow(ResultSet rs) throws SQLException {
        String javaType = rs.getString("class");
        Serializable identifier = (Serializable)rs.getObject("obj_id");
        identifier = this.aclClassIdUtils.identifierFrom(identifier, rs);
        return this.objectIdentityGenerator.createObjectIdentity(identifier, javaType);
    }

    @Override
    public Acl readAclById(ObjectIdentity object, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> map = this.readAclsById(Collections.singletonList(object), sids);
        Assert.isTrue((boolean)map.containsKey(object), () -> "There should have been an Acl entry for ObjectIdentity " + String.valueOf(object));
        return map.get(object);
    }

    @Override
    public Acl readAclById(ObjectIdentity object) throws NotFoundException {
        return this.readAclById(object, null);
    }

    @Override
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects) throws NotFoundException {
        return this.readAclsById(objects, null);
    }

    @Override
    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> objects, List<Sid> sids) throws NotFoundException {
        Map<ObjectIdentity, Acl> result = this.lookupStrategy.readAclsById(objects, sids);
        for (ObjectIdentity oid : objects) {
            if (result.containsKey(oid)) continue;
            throw new NotFoundException("Unable to find ACL information for object identity '" + String.valueOf(oid) + "'");
        }
        return result;
    }

    public void setFindChildrenQuery(String findChildrenSql) {
        this.findChildrenSql = findChildrenSql;
    }

    public void setAclClassIdSupported(boolean aclClassIdSupported) {
        this.aclClassIdSupported = aclClassIdSupported;
        if (aclClassIdSupported) {
            if (this.findChildrenSql.equals(DEFAULT_SELECT_ACL_WITH_PARENT_SQL)) {
                this.findChildrenSql = DEFAULT_SELECT_ACL_WITH_PARENT_SQL_WITH_CLASS_ID_TYPE;
            } else {
                log.debug((Object)"Find children statement has already been overridden, so not overridding the default");
            }
        }
    }

    public void setConversionService(ConversionService conversionService) {
        this.aclClassIdUtils = new AclClassIdUtils(conversionService);
    }

    public void setObjectIdentityGenerator(ObjectIdentityGenerator objectIdentityGenerator) {
        Assert.notNull((Object)objectIdentityGenerator, (String)"objectIdentityGenerator cannot be null");
        this.objectIdentityGenerator = objectIdentityGenerator;
    }

    protected boolean isAclClassIdSupported() {
        return this.aclClassIdSupported;
    }
}

