/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;

public class FilterChainProxyConfigTests {
    private ClassPathXmlApplicationContext appCtx;

    @Before
    public void loadContext() {
        System.setProperty("sec1235.pattern1", "/login");
        System.setProperty("sec1235.pattern2", "/logout");
        this.appCtx = new ClassPathXmlApplicationContext("org/springframework/security/util/filtertest-valid.xml");
    }

    @After
    public void closeContext() {
        if (this.appCtx != null) {
            this.appCtx.close();
        }
    }

    @Test(expected=BeanCreationException.class)
    public void misplacedUniversalPathShouldBeDetected() throws Exception {
        this.appCtx.getBean("newFilterChainProxyWrongPathOrder", FilterChainProxy.class);
    }

    @Test
    public void normalOperation() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("filterChain", FilterChainProxy.class);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void normalOperationWithNewConfig() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxy", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void normalOperationWithNewConfigRegex() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyRegex", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void normalOperationWithNewConfigNonNamespace() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNonNamespace", FilterChainProxy.class);
        this.checkPathAndFilterOrder(filterChainProxy);
        this.doNormalOperation(filterChainProxy);
    }

    @Test
    public void pathWithNoMatchHasNoFilters() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNoDefaultPath", FilterChainProxy.class);
        Assert.assertEquals(null, (Object)filterChainProxy.getFilters("/nomatch"));
    }

    @Test
    public void urlStrippingPropertyIsRespected() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("newFilterChainProxyNoDefaultPath", FilterChainProxy.class);
        String url = "/blah.bar?x=something";
        Assert.assertNotNull((Object)filterChainProxy.getFilters(url));
        Assert.assertEquals((long)2L, (long)filterChainProxy.getFilters(url).size());
        filterChainProxy.setStripQueryStringFromUrls(false);
        Assert.assertNull((Object)filterChainProxy.getFilters(url));
    }

    @Test
    public void mixingPatternsAndPlaceholdersDoesntCauseOrderingIssues() throws Exception {
        FilterChainProxy filterChainProxy = (FilterChainProxy)this.appCtx.getBean("sec1235FilterChainProxy", FilterChainProxy.class);
        String[] paths = filterChainProxy.getFilterChainMap().keySet().toArray(new String[0]);
        Assert.assertEquals((Object)"/login*", (Object)paths[0]);
        Assert.assertEquals((Object)"/logout", (Object)paths[1]);
        Assert.assertEquals((Object)"/**", (Object)paths[2]);
    }

    private void checkPathAndFilterOrder(FilterChainProxy filterChainProxy) throws Exception {
        List filters = filterChainProxy.getFilters("/foo/blah");
        Assert.assertEquals((long)1L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof SecurityContextHolderAwareRequestFilter));
        filters = filterChainProxy.getFilters("/some/other/path/blah");
        Assert.assertNotNull((Object)filters);
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof SecurityContextPersistenceFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof SecurityContextHolderAwareRequestFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof SecurityContextHolderAwareRequestFilter));
        filters = filterChainProxy.getFilters("/do/not/filter");
        Assert.assertEquals((long)0L, (long)filters.size());
        filters = filterChainProxy.getFilters("/another/nonspecificmatch");
        Assert.assertEquals((long)3L, (long)filters.size());
        Assert.assertTrue((boolean)(filters.get(0) instanceof SecurityContextPersistenceFilter));
        Assert.assertTrue((boolean)(filters.get(1) instanceof UsernamePasswordAuthenticationFilter));
        Assert.assertTrue((boolean)(filters.get(2) instanceof SecurityContextHolderAwareRequestFilter));
    }

    private void doNormalOperation(FilterChainProxy filterChainProxy) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/foo/secure/super/somefile.html");
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
        request.setServletPath("/a/path/which/doesnt/match/any/filter.html");
        chain = (FilterChain)Mockito.mock(FilterChain.class);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Matchers.any(HttpServletRequest.class), (ServletResponse)Matchers.any(HttpServletResponse.class));
    }
}

